/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.permission.RelationPermission;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.ChunkSettingsMenu;
import org.leralix.tan.gui.user.territory.OpenPlayerListForChunkPermission;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.text.TanChatUtils;

public class TerritoryChunkSettingsMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public TerritoryChunkSettingsMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_CHUNK_PERMISSION, 4);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getChunkPermission(), p -> new ChunkSettingsMenu(this.player, this.territoryData), Material.LIME_STAINED_GLASS_PANE);
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getChunkPermission() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (ChunkPermissionType type : ChunkPermissionType.values()) {
            RelationPermission permission = this.territoryData.getPermission(type).getOverallPermission();
            GuiItem item = this.iconManager.get(type.getIconKey()).setName(type.getName().get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_CLAIM_SETTINGS_DESC1.get(this.tanPlayer, permission.getColoredName(this.langType)), Lang.GUI_GENERIC_CLICK_TO_MODIFY.get(this.tanPlayer), Lang.GUI_RIGHT_CLICK_TO_ADD_SPECIFIC_PLAYER.get(this.tanPlayer)).setAction(event -> {
                event.setCancelled(true);
                if (!this.territoryData.doesPlayerHavePermission(this.player, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                    return;
                }
                if (event.isLeftClick()) {
                    this.territoryData.nextPermission(type);
                    this.open();
                } else if (event.isRightClick()) {
                    new OpenPlayerListForChunkPermission(this.player, this.territoryData, type, this);
                }
            }).asGuiItem(this.player);
            guiItems.add(item);
        }
        return guiItems;
    }
}

