/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.cosmetic.CustomIcon;
import org.leralix.tan.enums.BrowseScope;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.BrowseTerritoryMenu;
import org.leralix.tan.gui.user.territory.BuildingMenu;
import org.leralix.tan.gui.user.territory.ChunkSettingsMenu;
import org.leralix.tan.gui.user.territory.SelectTerritoryHeadMenu;
import org.leralix.tan.gui.user.territory.TerritoryMemberMenu;
import org.leralix.tan.gui.user.territory.TreasuryMenu;
import org.leralix.tan.gui.user.territory.WarsMenu;
import org.leralix.tan.gui.user.territory.relation.OpenDiplomacyMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.text.TanChatUtils;

public abstract class TerritoryMenu
extends BasicGui {
    protected final TerritoryData territoryData;

    protected TerritoryMenu(Player player, String name, TerritoryData territoryData) {
        super(player, name, 4);
        this.territoryData = territoryData;
    }

    protected GuiItem getTerritoryInfo() {
        LangType langType = this.tanPlayer.getLang();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(Lang.GUI_TOWN_INFO_DESC0.get(langType, this.territoryData.getDescription()));
        lore.add(Lang.GUI_TOWN_INFO_DESC1.get(langType, this.territoryData.getLeaderName()));
        lore.add(Lang.GUI_TOWN_INFO_DESC2.get(langType, Integer.toString(this.territoryData.getPlayerIDList().size())));
        lore.add(Lang.GUI_TOWN_INFO_DESC3.get(langType, Integer.toString(this.territoryData.getNumberOfClaimedChunk())));
        lore.add(this.territoryData.getOverlord().map(overlord -> Lang.GUI_TOWN_INFO_DESC5_REGION.get(langType, overlord.getName())).orElseGet(() -> Lang.GUI_TOWN_INFO_DESC5_NO_REGION.get(langType, new String[0])));
        lore.add(Lang.GUI_TOWN_INFO_CHANGE_ICON.get(this.tanPlayer));
        lore.add(Lang.RIGHT_CLICK_TO_SELECT_MEMBER_HEAD.get(this.tanPlayer));
        return this.iconManager.get(IconKey.TERRITORY_ICON).setName(Lang.GUI_TOWN_NAME.get(langType, this.territoryData.getName())).setDescription(lore).setAction(action -> {
            if (action.isRightClick()) {
                new SelectTerritoryHeadMenu(this.player, this.territoryData);
                return;
            }
            if (action.getCursor() == null) {
                return;
            }
            if (action.getCursor().getType() == Material.AIR) {
                return;
            }
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.TOWN_ADMINISTRATOR)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(langType, new String[0]), SoundEnum.NOT_ALLOWED);
                return;
            }
            ItemStack itemMaterial = action.getCursor();
            this.territoryData.setIcon(new CustomIcon(itemMaterial));
            TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_CHANGED_ICON_SUCCESS.get(langType, new String[0]), SoundEnum.GOOD);
            this.open();
        }).asGuiItem(this.player);
    }

    protected GuiItem getTownTreasuryButton() {
        return this.iconManager.get(IconKey.TERRITORY_TREASURY_ICON).setName(Lang.GUI_TOWN_TREASURY_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_TOWN_TREASURY_ICON_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new TreasuryMenu(this.player, this.territoryData)).asGuiItem(this.player);
    }

    protected GuiItem getMemberButton() {
        return this.iconManager.get(IconKey.TERRITORY_MEMBER_ICON).setName(Lang.GUI_TOWN_MEMBERS_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_TOWN_MEMBERS_ICON_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new TerritoryMemberMenu(this.player, this.territoryData).open()).asGuiItem(this.player);
    }

    protected GuiItem getLandButton() {
        return this.iconManager.get(IconKey.TERRITORY_LAND_ICON).setName(Lang.GUI_CLAIM_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_CLAIM_ICON_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new ChunkSettingsMenu(this.player, this.territoryData)).asGuiItem(this.player);
    }

    protected GuiItem getBrowseButton() {
        return this.iconManager.get(IconKey.TERRITORY_BROWSE_ICON).setName(Lang.GUI_BROWSE_TERRITORY_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new BrowseTerritoryMenu(this.player, this.territoryData, BrowseScope.ALL, p -> this.territoryData.openMainMenu(this.player))).asGuiItem(this.player);
    }

    protected GuiItem getDiplomacyButton() {
        return this.iconManager.get(IconKey.TERRITORY_DIPLOMACY_ICON).setName(Lang.GUI_RELATION_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_RELATION_ICON_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new OpenDiplomacyMenu(this.player, this.territoryData)).asGuiItem(this.player);
    }

    protected GuiItem getAttackButton() {
        return this.iconManager.get(IconKey.TERRITORY_WAR_ICON).setName(Lang.GUI_ATTACK_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_ATTACK_ICON_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new WarsMenu(this.player, this.territoryData)).asGuiItem(this.player);
    }

    protected GuiItem getHierarchyButton() {
        return this.iconManager.get(IconKey.TERRITORY_HIERARCHY_ICON).setName(Lang.GUI_HIERARCHY_MENU.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_HIERARCHY_MENU_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> PlayerGUI.openHierarchyMenu(this.player, this.territoryData)).asGuiItem(this.player);
    }

    protected GuiItem getBuildingButton() {
        return this.iconManager.get(IconKey.TERRITORY_BUILDING_ICON).setName(Lang.GUI_BUILDING_MENU.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_BUILDING_MENU_DESC1.get(this.tanPlayer.getLang(), new String[0]), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer.getLang(), new String[0])).setAction(event -> new BuildingMenu(this.player, this.territoryData, this)).asGuiItem(this.player);
    }
}

