/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.TownDeletedInternalEvent;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.SelectNewOwnerForTownMenu;
import org.leralix.tan.gui.user.territory.SettingsMenus;
import org.leralix.tan.gui.user.territory.TownMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangeTownTag;
import org.leralix.tan.listeners.interact.RightClickListener;
import org.leralix.tan.listeners.interact.events.ChangeCapital;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.file.FileUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class TownSettingsMenu
extends SettingsMenus {
    private final TownData townData;

    public TownSettingsMenu(Player player, TownData townData) {
        super(player, Lang.HEADER_SETTINGS.get(player), townData, 4);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getTerritoryInfo());
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.BLUE_STAINED_GLASS_PANE));
        this.gui.setItem(2, 2, this.getRenameButton());
        this.gui.setItem(2, 3, this.getChangeDescriptionButton());
        this.gui.setItem(2, 4, this.getChangeColorButton());
        this.gui.setItem(3, 2, this.getChangeApplicationButton());
        this.gui.setItem(3, 3, this.getChangeCapitalChunkButton());
        if (Constants.enableTownTag()) {
            this.gui.setItem(3, 4, this.getChangeTagButton());
        }
        this.gui.setItem(2, 6, this.getChangeOwnershipButton());
        this.gui.setItem(2, 7, this.getQuitButton());
        this.gui.setItem(2, 8, this.getDeleteButton());
        this.gui.setItem(4, 1, GuiUtil.createBackArrow(this.player, p -> new TownMenu(this.player, this.townData)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getChangeCapitalChunkButton() {
        ArrayList<String> desc = new ArrayList<String>();
        this.townData.getCapitalLocation().ifPresentOrElse(vector2D -> {
            desc.add(Lang.GUI_CAPITAL_CHUNK_ACTUAL_POSITION.get(this.langType, Lang.DISPLAY_2D_COORDINATES.get(this.langType, Integer.toString(vector2D.getX() * 16), Integer.toString(vector2D.getZ() * 16))));
            desc.add(Lang.GUI_GENERIC_CLICK_TO_MODIFY.get(this.langType, new String[0]));
        }, () -> desc.add(Lang.GUI_NO_CAPITAL_CHUNK.get(this.langType, new String[0])));
        return this.iconManager.get(IconKey.CHANGE_TOWN_CAPITAL_ICON).setName(Lang.GUI_TOWN_SETTINGS_CHANGE_CAPITAL.get(this.langType, new String[0])).setDescription(desc).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.TOWN_ADMINISTRATOR)) {
                TanChatUtils.message(this.player, Lang.NOT_TOWN_LEADER_ERROR.get(this.tanPlayer));
                return;
            }
            RightClickListener.register(this.player, new ChangeCapital(this.townData, p -> this.open()));
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getChangeTagButton() {
        return this.iconManager.get(IconKey.CHANGE_TOWN_TAG_ICON).setName(Lang.GUI_TOWN_SETTINGS_CHANGE_TAG.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_SETTINGS_CHANGE_TAG_DESC1.get(this.langType, this.townData.getColoredTag()), Lang.GUI_GENERIC_CLICK_TO_MODIFY.get(this.langType, new String[0])).setAction(action -> {
            TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
            PlayerChatListenerStorage.register(this.player, new ChangeTownTag(this.townData, p -> this.open()));
        }).asGuiItem(this.player);
    }

    private GuiItem getQuitButton() {
        return this.iconManager.get(IconKey.TOWN_QUIT_TOWN_ICON).setName(Lang.GUI_TOWN_SETTINGS_LEAVE_TOWN.get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_SETTINGS_LEAVE_TOWN_DESC1.get(this.tanPlayer, this.townData.getName()), Lang.GUI_TOWN_SETTINGS_LEAVE_TOWN_DESC2.get(this.tanPlayer)).setAction(event -> {
            RegionData regionData;
            event.setCancelled(true);
            if (!this.player.hasPermission("tan.base.town.quit")) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.langType, new String[0]), SoundEnum.NOT_ALLOWED);
                return;
            }
            if (this.townData.isLeader(this.tanPlayer)) {
                TanChatUtils.message(this.player, Lang.CHAT_CANT_LEAVE_TOWN_IF_LEADER.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            if (this.townData.haveOverlord() && (regionData = this.townData.getRegion()).isLeader(this.tanPlayer)) {
                TanChatUtils.message(this.player, Lang.CHAT_CANT_LEAVE_TOWN_IF_REGION_LEADER.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
            }
            PlayerGUI.openConfirmMenu(this.player, Lang.GUI_CONFIRM_PLAYER_LEAVE_TOWN.get(this.tanPlayer, this.tanPlayer.getNameStored()), confirm -> {
                this.player.closeInventory();
                this.townData.removePlayer(this.tanPlayer);
                TanChatUtils.message(this.player, Lang.CHAT_PLAYER_LEFT_THE_TOWN.get(this.tanPlayer));
                this.townData.broadcastMessageWithSound(Lang.TOWN_BROADCAST_PLAYER_LEAVE_THE_TOWN.get(this.tanPlayer.getNameStored()), SoundEnum.BAD);
            }, remove -> this.open());
        }).asGuiItem(this.player);
    }

    private GuiItem getDeleteButton() {
        return this.iconManager.get(IconKey.TOWN_DELETE_TOWN_ICON).setName(Lang.GUI_TOWN_SETTINGS_DELETE_TOWN.get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_SETTINGS_DELETE_TOWN_DESC1.get(this.tanPlayer, this.townData.getName()), Lang.GUI_TOWN_SETTINGS_DELETE_TOWN_DESC2.get(this.tanPlayer)).setAction(event -> {
            event.setCancelled(true);
            if (!this.townData.isLeader(this.tanPlayer)) {
                TanChatUtils.message(this.player, Lang.CHAT_CANT_DISBAND_TOWN_IF_NOT_LEADER.get(this.tanPlayer));
                return;
            }
            if (this.townData.isCapital()) {
                TanChatUtils.message(this.player, Lang.CANNOT_DELETE_TERRITORY_IF_CAPITAL.get(this.tanPlayer, this.townData.getOverlord().get().getBaseColoredName()));
                return;
            }
            if (!this.player.hasPermission("tan.base.town.disband")) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            PlayerGUI.openConfirmMenu(this.player, Lang.GUI_CONFIRM_PLAYER_DELETE_TOWN.get(this.tanPlayer, this.townData.getName()), confirm -> {
                FileUtil.addLineToHistory(Lang.TOWN_DELETED_NEWSLETTER.get(this.player.getName(), this.townData.getName()));
                EventManager.getInstance().callEvent(new TownDeletedInternalEvent(this.townData, this.tanPlayer));
                this.townData.delete();
                this.player.closeInventory();
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.GOOD);
            }, remove -> this.open());
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getChangeApplicationButton() {
        IconKey iconKey = this.townData.isRecruiting() ? IconKey.TOWN_ALLOW_APPLICATION_ICON : IconKey.TOWN_DENY_APPLICATION_ICON;
        return this.iconManager.get(iconKey).setName(Lang.GUI_TOWN_SETTINGS_CHANGE_TOWN_APPLICATION.get(this.tanPlayer)).setDescription(this.townData.isRecruiting() ? Lang.GUI_TOWN_SETTINGS_CHANGE_TOWN_APPLICATION_ACCEPT.get(this.tanPlayer) : Lang.GUI_TOWN_SETTINGS_CHANGE_TOWN_APPLICATION_NOT_ACCEPT.get(this.tanPlayer), Lang.GUI_GENERIC_CLICK_TO_SWITCH.get(this.tanPlayer)).setAction(event -> {
            this.townData.swapRecruiting();
            this.open();
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getChangeOwnershipButton() {
        return this.iconManager.get(IconKey.TOWN_CHANGE_OWNERSHIP_ICON).setName(Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP.get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_DESC1.get(this.tanPlayer), Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_DESC2.get(this.tanPlayer)).setAction(event -> {
            if (this.townData.isLeader(this.tanPlayer)) {
                new SelectNewOwnerForTownMenu(this.player, this.townData);
            } else {
                TanChatUtils.message(this.player, Lang.NOT_TOWN_LEADER_ERROR.get(this.tanPlayer));
            }
        }).asGuiItem(this.player);
    }
}

