/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.economy.Budget;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.EconomicHistoryMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.DonateToTerritory;
import org.leralix.tan.listeners.chat.events.RetrieveMoney;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class TreasuryMenu
extends BasicGui {
    protected final TerritoryData territoryData;
    protected final Budget budget;

    public TreasuryMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_ECONOMY, 5);
        this.territoryData = territoryData;
        this.budget = territoryData.getBudget();
        this.open();
    }

    @Override
    public void open() {
        this.budget.createGui(this.gui, this.player, this.langType);
        this.gui.setItem(1, 5, this.getBudgetIcon());
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.YELLOW_STAINED_GLASS_PANE));
        this.gui.setItem(2, 8, this.getMiscSpendingsIcon());
        this.gui.setItem(3, 2, this.getDonationButton());
        this.gui.setItem(3, 3, this.getDonationHistoryButton());
        this.gui.setItem(3, 4, this.getRetrieveButton());
        this.gui.setItem(5, 1, GuiUtil.createBackArrow(this.player, p -> this.territoryData.openMainMenu(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    protected GuiItem getBudgetIcon() {
        ArrayList<String> description = new ArrayList<String>();
        description.add(Lang.GUI_TREASURY_STORAGE_DESC1.get(this.tanPlayer, Double.toString(this.territoryData.getBalance())));
        description.addAll(this.budget.createLore(this.tanPlayer.getLang()));
        return this.iconManager.get(IconKey.BUDGET_ICON).setName(Lang.GUI_TREASURY_STORAGE.get(this.tanPlayer)).setDescription(description).asGuiItem(this.player);
    }

    protected GuiItem getMiscSpendingsIcon() {
        return this.iconManager.get(IconKey.MISCELLANEOUS_SPENDING_ICON).setName(Lang.GUI_TREASURY_MISCELLANEOUS_SPENDING.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN_HISTORY.get(this.tanPlayer)).setAction(action -> new EconomicHistoryMenu(this.player, this.territoryData, TransactionHistoryEnum.MISCELLANEOUS)).asGuiItem(this.player);
    }

    protected GuiItem getDonationButton() {
        return this.iconManager.get(IconKey.DONATION_ICON).setName(Lang.GUI_TREASURY_DONATION.get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_TREASURY_DONATION_DESC1.get(this.tanPlayer)).setAction(action -> {
            TanChatUtils.message(this.player, Lang.WRITE_IN_CHAT_AMOUNT_OF_MONEY_FOR_DONATION.get(this.tanPlayer));
            PlayerChatListenerStorage.register(this.player, new DonateToTerritory(this.territoryData));
        }).asGuiItem(this.player);
    }

    protected GuiItem getDonationHistoryButton() {
        return this.iconManager.get(IconKey.DONATION_HISTORY_ICON).setName(Lang.GUI_TREASURY_DONATION_HISTORY.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN_HISTORY.get(this.tanPlayer)).setAction(action -> new EconomicHistoryMenu(this.player, this.territoryData, TransactionHistoryEnum.DONATION)).asGuiItem(this.player);
    }

    protected GuiItem getRetrieveButton() {
        return this.iconManager.get(IconKey.RETRIEVE_MONEY_ICON).setName(Lang.GUI_TREASURY_RETRIEVE_GOLD.get(this.tanPlayer)).setDescription(Lang.GUI_TREASURY_RETRIEVE_GOLD_DESC1.get(this.tanPlayer)).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_TAXES)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                return;
            }
            TanChatUtils.message(this.player, Lang.PLAYER_WRITE_QUANTITY_IN_CHAT.get(this.tanPlayer));
            PlayerChatListenerStorage.register(this.player, new RetrieveMoney(this.territoryData));
        }).asGuiItem(this.player);
    }
}

