/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.relation;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.relation.OpenDiplomacyProposalsMenu;
import org.leralix.tan.gui.user.territory.relation.OpenRelationMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.constants.RelationConstant;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class OpenDiplomacyMenu
extends BasicGui {
    private final TerritoryData territoryData;

    public OpenDiplomacyMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_RELATIONS.get(player, territoryData.getName()), 3);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(9, this.getWarButton());
        this.gui.setItem(11, this.getEmbargoButton());
        this.gui.setItem(13, this.getNonAggressionPactButton());
        this.gui.setItem(15, this.getAllianceButton());
        this.gui.setItem(17, this.getProposalButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> PlayerGUI.dispatchPlayerTown(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getWarButton() {
        List<String> desc = this.generateDescription(Lang.GUI_TOWN_RELATION_HOSTILE_DESC1.get(this.langType, new String[0]), TownRelation.WAR);
        return this.iconManager.get(IconKey.GUI_WAR_ICON).setName(Lang.GUI_TOWN_RELATION_HOSTILE.get(this.langType, new String[0])).setDescription(desc).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.WAR)).asGuiItem(this.player);
    }

    private GuiItem getEmbargoButton() {
        List<String> desc = this.generateDescription(Lang.GUI_TOWN_RELATION_EMBARGO_DESC1.get(this.langType, new String[0]), TownRelation.EMBARGO);
        return this.iconManager.get(IconKey.GUI_EMBARGO_ICON).setName(Lang.GUI_TOWN_RELATION_EMBARGO.get(this.langType, new String[0])).setDescription(desc).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.EMBARGO)).asGuiItem(this.player);
    }

    private GuiItem getNonAggressionPactButton() {
        List<String> desc = this.generateDescription(Lang.GUI_TOWN_RELATION_NAP_DESC1.get(this.langType, new String[0]), TownRelation.NON_AGGRESSION);
        return this.iconManager.get(IconKey.GUI_NON_AGGRESSION_PACT_ICON).setName(Lang.GUI_TOWN_RELATION_NAP.get(this.langType, new String[0])).setDescription(desc).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.NON_AGGRESSION)).asGuiItem(this.player);
    }

    private GuiItem getAllianceButton() {
        List<String> desc = this.generateDescription(Lang.GUI_TOWN_RELATION_ALLIANCE_DESC1.get(this.langType, new String[0]), TownRelation.ALLIANCE);
        return this.iconManager.get(IconKey.GUI_ALLIANCE_ICON).setName(Lang.GUI_TOWN_RELATION_ALLIANCE.get(this.langType, new String[0])).setDescription(desc).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.ALLIANCE)).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getProposalButton() {
        return this.iconManager.get(IconKey.GUI_PROPOSALS_ICON).setName(Lang.GUI_TOWN_RELATION_DIPLOMACY_PROPOSAL.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_RELATION_DIPLOMACY_PROPOSAL_DESC1.get(this.tanPlayer), Lang.GUI_TOWN_RELATION_DIPLOMACY_PROPOSAL_DESC2.get(this.tanPlayer, Integer.toString(this.territoryData.getAllDiplomacyProposal().size()))).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_TOWN_RELATION)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                return;
            }
            new OpenDiplomacyProposalsMenu(this.player, this.territoryData);
        }).asGuiItem(this.player);
    }

    private List<String> generateDescription(String description, TownRelation relation) {
        int blockCommandsSize;
        ArrayList<String> res = new ArrayList<String>();
        res.add(description);
        RelationConstant relationConstant = Constants.getRelationConstants(relation);
        int trucePeriod = relationConstant.trucePeriod();
        if (trucePeriod > 0) {
            res.add(Lang.GUI_RELATION_TRUCE.get(this.langType, Integer.toString(trucePeriod)));
        }
        if (relationConstant.canPvP()) {
            res.add(Lang.GUI_RELATION_ENABLE_PVP.get(this.langType, new String[0]));
        } else {
            res.add(Lang.GUI_RELATION_DISABLE_PVP.get(this.langType, new String[0]));
        }
        if (relationConstant.canInteractWithProperty()) {
            res.add(Lang.GUI_RELATION_ENABLE_PROPERTY.get(this.langType, new String[0]));
        } else {
            res.add(Lang.GUI_RELATION_DISABLE_PROPERTY.get(this.langType, new String[0]));
        }
        if (!relationConstant.canAccessTerritory()) {
            res.add(Lang.GUI_RELATION_BLOCK_ENTRY.get(this.langType, new String[0]));
        }
        if ((blockCommandsSize = relationConstant.getBlockedCommands().size()) > 0) {
            res.add(Lang.GUI_RELATION_DISABLE_COMMANDS.get(this.langType, Integer.toString(blockCommandsSize)));
        }
        if (relation == TownRelation.WAR) {
            res.add(Lang.GUI_RELATION_ENABLE_WAR.get(this.langType, new String[0]));
        }
        res.add("");
        res.add(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.langType, new String[0]));
        return res;
    }
}

