/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.relation;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.relation.AddRelationMenu;
import org.leralix.tan.gui.user.territory.relation.OpenDiplomacyMenu;
import org.leralix.tan.gui.user.territory.relation.RemoveRelationMenu;
import org.leralix.tan.gui.user.war.WarMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.utils.text.TanChatUtils;
import org.leralix.tan.war.War;

public class OpenRelationMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final TownRelation relation;

    public OpenRelationMenu(Player player, TerritoryData territoryData, TownRelation relation) {
        super(player, Lang.HEADER_RELATION_WITH.get(player, relation.getName(PlayerDataStorage.getInstance().get(player).getLang())), 6);
        this.territoryData = territoryData;
        this.relation = relation;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getTerritories(), p -> new OpenDiplomacyMenu(this.player, this.territoryData));
        this.gui.setItem(6, 4, this.getRemoveTerritoryButton());
        this.gui.setItem(6, 5, this.getAddTerritoryButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getRemoveTerritoryButton() {
        return this.iconManager.get(IconKey.GUI_REMOVE_TERRITORY_ICON).setName(Lang.GUI_TOWN_RELATION_REMOVE_TOWN.get(this.tanPlayer)).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_TOWN_RELATION)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                return;
            }
            new RemoveRelationMenu(this.player, this.territoryData, this.relation);
        }).asGuiItem(this.player);
    }

    private GuiItem getAddTerritoryButton() {
        return this.iconManager.get(IconKey.GUI_ADD_TERRITORY_ICON).setName(Lang.GUI_TOWN_RELATION_ADD_TOWN.get(this.tanPlayer)).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_TOWN_RELATION)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                return;
            }
            new AddRelationMenu(this.player, this.territoryData, this.relation);
        }).asGuiItem(this.player);
    }

    private List<GuiItem> getTerritories() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String territoryID : this.territoryData.getRelations().getTerritoriesIDWithRelation(this.relation)) {
            TerritoryData otherTerritory = TerritoryUtil.getTerritory(territoryID);
            ItemStack icon = otherTerritory.getIconWithInformationAndRelation(this.territoryData, this.tanPlayer.getLang());
            if (this.relation == TownRelation.WAR) {
                ItemMeta meta = icon.getItemMeta();
                assert (meta != null);
                List lore = meta.getLore();
                assert (lore != null);
                lore.add(Lang.GUI_TOWN_ATTACK_TOWN_DESC1.get(this.tanPlayer));
                meta.setLore(lore);
                icon.setItemMeta(meta);
            }
            GuiItem townButton = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (this.relation == TownRelation.WAR && event.isRightClick()) {
                    WarStorage warStorage = WarStorage.getInstance();
                    if (warStorage.isTerritoryAtWarWith(this.territoryData, otherTerritory)) {
                        TanChatUtils.message(this.player, Lang.GUI_TOWN_ATTACK_ALREADY_ATTACKING.get(this.tanPlayer));
                        SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                        return;
                    }
                    this.territoryData.broadcastMessageWithSound(Lang.GUI_WAR_DECLARED.get(this.territoryData.getColoredName(), otherTerritory.getColoredName()), SoundEnum.WAR);
                    otherTerritory.broadcastMessageWithSound(Lang.GUI_WAR_DECLARED.get(this.territoryData.getColoredName(), otherTerritory.getColoredName()), SoundEnum.WAR);
                    War newWar = warStorage.newWar(this.territoryData, otherTerritory);
                    new WarMenu(this.player, this.territoryData, newWar);
                }
            });
            guiItems.add(townButton);
        }
        return guiItems;
    }
}

