/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.lang;

import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.lang.LangType;

public class DynamicLang {
    private static LangType serverLang;
    private static final EnumMap<LangType, Map<String, String>> values;

    public static void loadTranslations(File folder, String fileTag) {
        serverLang = LangType.fromCode(fileTag);
        if (!folder.exists()) {
            folder.mkdir();
        }
        for (LangType langType : LangType.values()) {
            File SpecificLangFolder = new File(folder, langType.getCode());
            if (!SpecificLangFolder.exists()) {
                SpecificLangFolder.mkdir();
            }
            File file = new File(SpecificLangFolder, "upgrades.yml");
            ConfigUtil.saveAndUpdateResource((Plugin)TownsAndNations.getPlugin(), (String)("lang/" + langType.getCode() + "/upgrades.yml"), Collections.singletonList("customLang"));
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            HashMap<String, String> values = new HashMap<String, String>();
            ConfigurationSection configurationSection = config.getConfigurationSection("customLang");
            if (configurationSection == null) {
                DynamicLang.values.put(langType, Collections.emptyMap());
                continue;
            }
            for (String key : configurationSection.getKeys(false)) {
                String value = configurationSection.getString(key);
                values.put(key, value);
            }
            DynamicLang.values.put(langType, values);
        }
    }

    public static String get(LangType langType, String key) {
        String line = values.get((Object)langType).get(key);
        if (line == null) {
            if (langType == serverLang) {
                return key;
            }
            return DynamicLang.get(serverLang, key);
        }
        return line;
    }

    static {
        values = new EnumMap(LangType.class);
    }
}

