/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners;

import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.chunk.WildernessChunk;
import org.leralix.tan.enums.ChunkType;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.PlayerAutoClaimStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.text.TanChatUtils;

public class PlayerEnterChunkListener
implements Listener {
    private final boolean displayTerritoryNamewithColor = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("displayTerritoryNameWithOwnColor");
    private final NewClaimedChunkStorage newClaimedChunkStorage = NewClaimedChunkStorage.getInstance();
    private final PlayerDataStorage playerDataStorage = PlayerDataStorage.getInstance();

    @EventHandler
    public void playerMoveEvent(@NotNull PlayerMoveEvent event) {
        ClaimedChunk2 nextClaimedChunk;
        Chunk nextChunk;
        Chunk currentChunk = event.getFrom().getChunk();
        if (currentChunk.equals((Object)(nextChunk = event.getTo().getChunk()))) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.newClaimedChunkStorage.isChunkClaimed(currentChunk) && !this.newClaimedChunkStorage.isChunkClaimed(nextChunk)) {
            if (PlayerAutoClaimStorage.containsPlayer(event.getPlayer())) {
                this.autoClaimChunk(event, nextChunk, player);
            }
            return;
        }
        ClaimedChunk2 currentClaimedChunk = this.newClaimedChunkStorage.get(currentChunk);
        if (PlayerEnterChunkListener.sameOwner(currentClaimedChunk, nextClaimedChunk = this.newClaimedChunkStorage.get(nextChunk))) {
            return;
        }
        if (nextClaimedChunk instanceof TerritoryChunk) {
            TerritoryChunk territoryChunk = (TerritoryChunk)nextClaimedChunk;
            ITanPlayer tanPlayer = this.playerDataStorage.get(player);
            TownRelation worstRelation = territoryChunk.getOwner().getWorstRelationWith(tanPlayer);
            if (!Constants.getRelationConstants(worstRelation).canAccessTerritory()) {
                event.setCancelled(true);
                LangType lang = tanPlayer.getLang();
                TanChatUtils.message(player, Lang.PLAYER_CANNOT_ENTER_CHUNK_WITH_RELATION.get(lang, territoryChunk.getOwner().getColoredName(), worstRelation.getColoredName(lang)));
                return;
            }
        }
        nextClaimedChunk.playerEnterClaimedArea(player, this.displayTerritoryNamewithColor);
        if (nextClaimedChunk instanceof WildernessChunk && PlayerAutoClaimStorage.containsPlayer(event.getPlayer())) {
            this.autoClaimChunk(event, nextChunk, player);
        }
    }

    private void autoClaimChunk(@NotNull PlayerMoveEvent e, @NotNull Chunk nextChunk, @NotNull Player player) {
        ChunkType chunkType = PlayerAutoClaimStorage.getChunkType(e.getPlayer());
        ITanPlayer playerStat = PlayerDataStorage.getInstance().get(player.getUniqueId().toString());
        if (chunkType == ChunkType.TOWN) {
            if (!playerStat.hasTown()) {
                TanChatUtils.message(player, Lang.PLAYER_NO_TOWN.get(player));
                return;
            }
            playerStat.getTown().claimChunk(player, nextChunk);
        }
        if (chunkType == ChunkType.REGION) {
            if (!playerStat.hasRegion()) {
                TanChatUtils.message(player, Lang.PLAYER_NO_REGION.get(player));
                return;
            }
            playerStat.getRegion().claimChunk(player, nextChunk);
        }
    }

    public static boolean sameOwner(ClaimedChunk2 a, ClaimedChunk2 b) {
        if (a == b) {
            return true;
        }
        return a.getOwnerID().equals(b.getOwnerID());
    }
}

