/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.configuration.file.FileConfiguration;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.storage.blacklist.BlackListWorld;
import org.leralix.tan.storage.blacklist.BlackListZone;
import org.leralix.tan.storage.blacklist.IBlackList;

public class ClaimBlacklistStorage {
    private static List<IBlackList> blacklist;

    private ClaimBlacklistStorage() {
        throw new IllegalStateException("Utility class");
    }

    public static void init() {
        blacklist = new ArrayList<IBlackList>();
        FileConfiguration config = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN);
        for (Object item : config.getList("claimBlacklist", Collections.emptyList())) {
            if (!(item instanceof Map)) continue;
            Map map = (Map)item;
            String name = (String)map.get("name");
            List coordinates = (List)map.get("coordinate");
            if (name == null) continue;
            if (coordinates == null) {
                blacklist.add(new BlackListWorld(name));
                continue;
            }
            if (coordinates.size() != 4) continue;
            blacklist.add(new BlackListZone(name, coordinates));
        }
    }

    public static boolean cannotBeClaimed(Chunk chunk) {
        for (IBlackList instance : blacklist) {
            if (!instance.isChunkInArea(chunk)) continue;
            return true;
        }
        return false;
    }

    public static boolean cannotBeClaimed(ClaimedChunk2 claimedChunk) {
        return ClaimBlacklistStorage.cannotBeClaimed(claimedChunk.getChunk());
    }
}

