/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage;

import java.util.EnumMap;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.permission.ChunkPermission;
import org.leralix.tan.dataclass.territory.permission.RelationPermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;

public class PermissionManager {
    private final EnumMap<ChunkPermissionType, ChunkPermission> chunkPermissions = new EnumMap(ChunkPermissionType.class);

    public PermissionManager(RelationPermission relationPermission) {
        this.setAll(relationPermission);
    }

    public void setAll(RelationPermission relationPermission) {
        this.chunkPermissions.clear();
        for (ChunkPermissionType type : ChunkPermissionType.values()) {
            this.chunkPermissions.put(type, new ChunkPermission(relationPermission));
        }
    }

    public boolean canPlayerDo(TerritoryData territoryToCheck, ChunkPermissionType action, ITanPlayer tanPlayer) {
        return this.get(action).isAllowed(territoryToCheck, tanPlayer);
    }

    public ChunkPermission get(ChunkPermissionType type) {
        return this.chunkPermissions.getOrDefault((Object)type, new ChunkPermission(RelationPermission.TOWN));
    }

    public void nextPermission(ChunkPermissionType type) {
        this.get(type).nextPermission();
    }
}

