/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.TeleportationData;
import org.leralix.tan.dataclass.TeleportationPosition;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.text.TanChatUtils;

public class TeleportationRegister {
    private static final HashMap<String, TeleportationData> spawnRegister = new HashMap();

    private TeleportationRegister() {
        throw new IllegalStateException("Utility class");
    }

    public static void registerSpawn(ITanPlayer player, TownData town) {
        spawnRegister.put(player.getID(), new TeleportationData(town.getSpawn()));
    }

    public static void removePlayer(ITanPlayer player) {
        spawnRegister.remove(player.getID());
    }

    public static boolean isPlayerRegistered(String playerID) {
        return spawnRegister.containsKey(playerID);
    }

    public static TeleportationData getTeleportationData(String playerID) {
        return spawnRegister.get(playerID);
    }

    public static TeleportationData getTeleportationData(ITanPlayer tanPlayer) {
        return TeleportationRegister.getTeleportationData(tanPlayer.getID());
    }

    public static TeleportationData getTeleportationData(Player player) {
        return TeleportationRegister.getTeleportationData(player.getUniqueId().toString());
    }

    public static void teleportToTownSpawn(ITanPlayer tanPlayer, TownData townData) {
        int secondBeforeTeleport = Constants.getTimeBeforeTeleport();
        Player player = Bukkit.getPlayer((UUID)tanPlayer.getUUID());
        if (player == null) {
            return;
        }
        LangType langType = tanPlayer.getLang();
        if (TeleportationRegister.isPlayerRegistered(tanPlayer.getID())) {
            TanChatUtils.message(player, Lang.WAIT_BEFORE_ANOTHER_TELEPORTATION.get(langType, new String[0]));
            return;
        }
        if (secondBeforeTeleport > 0) {
            if (Constants.isCancelTeleportOnMovePosition()) {
                TanChatUtils.message(player, Lang.TELEPORTATION_IN_X_SECONDS_NOT_MOVE.get(langType, Integer.toString(secondBeforeTeleport)));
            } else {
                TanChatUtils.message(player, Lang.TELEPORTATION_IN_X_SECONDS.get(langType, Integer.toString(secondBeforeTeleport)));
            }
            TeleportationRegister.registerSpawn(tanPlayer, townData);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)TownsAndNations.getPlugin(), () -> TeleportationRegister.confirmTeleportation(tanPlayer), (long)secondBeforeTeleport * 20L);
    }

    public static void confirmTeleportation(ITanPlayer tanPlayer) {
        if (!spawnRegister.containsKey(tanPlayer.getID())) {
            return;
        }
        if (spawnRegister.get(tanPlayer.getID()).isCancelled()) {
            TeleportationRegister.removePlayer(tanPlayer);
            return;
        }
        TeleportationPosition teleportationPosition = spawnRegister.get(tanPlayer.getID()).getTeleportationPosition();
        Player player = Bukkit.getPlayer((UUID)tanPlayer.getUUID());
        if (player != null) {
            teleportationPosition.teleport(player);
            TanChatUtils.message(player, Lang.SPAWN_TELEPORTED.get(tanPlayer), SoundEnum.MINOR_GOOD);
        }
        TeleportationRegister.removePlayer(tanPlayer);
    }
}

