/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.newhistory.TransactionHistory;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;

public abstract class DatabaseHandler {
    protected DataSource dataSource;

    public abstract void connect() throws SQLException;

    public void addTransactionHistory(TransactionHistory transactionHistory) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TownsAndNations.getPlugin(), () -> {
            this.checkIfHistoryDbExists();
            String insertSQL = "    INSERT INTO territoryTransactionHistory (date, type, territoryDataID, transactionParty, amount)\n    VALUES (?, ?, ?, ?, ?)\n";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(insertSQL);){
                preparedStatement.setString(1, transactionHistory.getDate());
                preparedStatement.setString(2, transactionHistory.getType().toString());
                preparedStatement.setString(3, transactionHistory.getTerritoryDataID());
                preparedStatement.setString(4, transactionHistory.getTransactionParty());
                preparedStatement.setDouble(5, transactionHistory.getAmount());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                TownsAndNations.getPlugin().getLogger().severe("Error while adding transaction history : " + e.getMessage());
            }
        });
    }

    public List<List<TransactionHistory>> getTransactionHistory(TerritoryData territoryData, TransactionHistoryEnum type) {
        String selectSQL = "    SELECT date, type, territoryDataID, transactionParty, amount\n    FROM territoryTransactionHistory\n    WHERE territoryDataID = ? AND type = ?\n    ORDER BY date\n";
        HashMap<String, List> groupedByDate = new HashMap<String, List>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(selectSQL);){
            preparedStatement.setString(1, territoryData.getID());
            preparedStatement.setString(2, type.toString());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String date = resultSet.getString("date");
                    TransactionHistoryEnum transactionHistoryEnum = TransactionHistoryEnum.valueOf(resultSet.getString("type"));
                    String territoryDataID = resultSet.getString("territoryDataID");
                    String transactionParty = resultSet.getString("transactionParty");
                    double amount = resultSet.getDouble("amount");
                    TransactionHistory transactionHistory = transactionHistoryEnum.createTransactionHistory(date, territoryDataID, transactionParty, amount);
                    groupedByDate.computeIfAbsent(date, k -> new ArrayList()).add(transactionHistory);
                }
            }
        }
        catch (SQLException e) {
            TownsAndNations.getPlugin().getLogger().severe("Error while getting transaction history");
        }
        return new ArrayList<List<TransactionHistory>>(groupedByDate.values());
    }

    public void deleteOldHistory(int nbDays, TransactionHistoryEnum type) {
        String deleteSQL = "    DELETE FROM territoryTransactionHistory\n    WHERE date < DATE('now', '-' || ? || ' days')\n    AND type != ?\n";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(deleteSQL);){
            preparedStatement.setInt(1, nbDays);
            preparedStatement.setString(2, type.toString());
        }
        catch (SQLException e) {
            TownsAndNations.getPlugin().getLogger().severe("Error while deleting old history : " + e.getMessage());
        }
    }

    protected void checkIfHistoryDbExists() {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            statement.execute("    CREATE TABLE IF NOT EXISTS territoryTransactionHistory (\n    date TEXT,\n    type TEXT,\n    territoryDataID TEXT,\n    transactionParty TEXT,\n    amount DOUBLE\n)\n");
        }
        catch (SQLException e) {
            TownsAndNations.getPlugin().getLogger().severe("Error while creating history table : " + e.getMessage());
        }
    }

    public void initialize() {
        this.checkIfHistoryDbExists();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

