/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.leralix.tan.storage.stored.JsonStorage;
import org.leralix.tan.utils.constants.Constants;

public class PremiumStorage
extends JsonStorage<Boolean> {
    private static PremiumStorage instance;

    private PremiumStorage() {
        super("Premium accounts.json", new TypeToken<HashMap<String, Boolean>>(){}.getType(), new GsonBuilder().setPrettyPrinting().create());
    }

    public static synchronized PremiumStorage getInstance() {
        if (instance == null) {
            instance = new PremiumStorage();
        }
        return instance;
    }

    public boolean isPremium(String playerName) {
        if (Constants.onlineMode()) {
            return true;
        }
        if (playerName == null) {
            return false;
        }
        String key = playerName.toLowerCase();
        if (this.dataMap.containsKey(key)) {
            return (Boolean)this.dataMap.get(key);
        }
        boolean premium = this.fetchPremium(playerName);
        this.dataMap.put(key, premium);
        return premium;
    }

    private boolean fetchPremium(String playerName) {
        block8: {
            boolean bl;
            block9: {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(2000);
                if (connection.getResponseCode() != 200) break block8;
                InputStream in = connection.getInputStream();
                try {
                    String json = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                    JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
                    boolean bl2 = bl = obj.has("id") && obj.has("name");
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                in.close();
            }
            return bl;
        }
        return false;
    }

    @Override
    public void reset() {
        instance = null;
    }
}

