/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.DefenderAcceptDemandsBeforeWarInternalEvent;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.CurrentAttacksStorage;
import org.leralix.tan.storage.stored.PlannedAttackStorage;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.utils.text.DateUtil;
import org.leralix.tan.war.War;
import org.leralix.tan.war.capture.CaptureManager;
import org.leralix.tan.war.legacy.CreateAttackData;
import org.leralix.tan.war.legacy.CurrentAttack;
import org.leralix.tan.war.legacy.WarRole;

public class PlannedAttack {
    private final String ID;
    private String name;
    private final Collection<String> defendersID;
    private final Collection<String> attackersID;
    final long startTime;
    private final long endTime;
    private final War war;
    private final WarRole warRole;
    private transient BukkitRunnable warStartTask;
    private transient BukkitRunnable warWarningTask;
    boolean isAdminApproved;

    public PlannedAttack(String id, CreateAttackData createAttackData) {
        this.ID = id;
        this.war = createAttackData.getWar();
        this.warRole = createAttackData.getAttackingSide();
        this.name = Lang.BASIC_ATTACK_NAME.get(Lang.getServerLang(), this.war.getMainAttacker().getName(), this.war.getMainDefender().getName());
        this.isAdminApproved = !ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("AdminApproval", false);
        this.attackersID = new ArrayList<String>();
        this.attackersID.add(this.war.getMainAttackerID());
        this.defendersID = new ArrayList<String>();
        this.defendersID.add(this.war.getMainDefenderID());
        this.startTime = new Date().getTime() + (long)createAttackData.getSelectedTime() * 60L * 1000L;
        this.endTime = this.startTime + Constants.getAttackDuration() * 60L * 1000L;
        this.war.getMainDefender().addPlannedAttack(this);
        this.war.getMainAttacker().addPlannedAttack(this);
        this.setUpStartOfAttack();
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public War getWar() {
        return this.war;
    }

    public boolean isAdminApproved() {
        return this.isAdminApproved;
    }

    public void setAdminApproved(boolean isAdminApproved) {
        this.isAdminApproved = isAdminApproved;
    }

    public Collection<ITanPlayer> getDefendingPlayers() {
        ArrayList<ITanPlayer> defenders = new ArrayList<ITanPlayer>();
        for (TerritoryData defendingTerritory : this.getDefendingTerritories()) {
            defenders.addAll(defendingTerritory.getITanPlayerList());
        }
        return defenders;
    }

    public Collection<ITanPlayer> getAttackersPlayers() {
        ArrayList<ITanPlayer> defenders = new ArrayList<ITanPlayer>();
        for (TerritoryData attackingTerritory : this.getAttackingTerritories()) {
            defenders.addAll(attackingTerritory.getITanPlayerList());
        }
        return defenders;
    }

    public Collection<TerritoryData> getDefendingTerritories() {
        ArrayList<TerritoryData> defenders = new ArrayList<TerritoryData>();
        for (String defenderID : this.defendersID) {
            defenders.add(TerritoryUtil.getTerritory(defenderID));
        }
        return defenders;
    }

    public Collection<TerritoryData> getAttackingTerritories() {
        ArrayList<TerritoryData> attackers = new ArrayList<TerritoryData>();
        for (String attackerID : this.attackersID) {
            attackers.add(TerritoryUtil.getTerritory(attackerID));
        }
        return attackers;
    }

    public void broadCastMessageWithSound(FilledLang message, SoundEnum soundEnum) {
        Collection<TerritoryData> territoryData = this.getAttackingTerritories();
        territoryData.addAll(this.getDefendingTerritories());
        for (TerritoryData territory : territoryData) {
            territory.broadcastMessageWithSound(message, soundEnum);
        }
    }

    public void setUpStartOfAttack() {
        long currentTime = new Date().getTime();
        long timeLeftBeforeStart = (long)((double)(this.startTime - currentTime) * 0.02);
        long timeLeftBeforeWarning = timeLeftBeforeStart - 1200L;
        if (timeLeftBeforeStart <= 0L) {
            this.startWar(this.startTime - timeLeftBeforeStart);
            return;
        }
        this.warStartTask = new BukkitRunnable(){

            public void run() {
                PlannedAttack.this.startWar(PlannedAttack.this.startTime);
            }
        };
        this.warStartTask.runTaskLater((Plugin)TownsAndNations.getPlugin(), timeLeftBeforeStart);
        if (timeLeftBeforeWarning > 0L) {
            this.warWarningTask = new BukkitRunnable(){

                public void run() {
                    PlannedAttack.this.broadCastMessageWithSound(Lang.ATTACK_START_IN_1_MINUTES.get(PlannedAttack.this.name), SoundEnum.WAR);
                }
            };
            this.warWarningTask.runTaskLater((Plugin)TownsAndNations.getPlugin(), timeLeftBeforeWarning);
        }
    }

    void startWar(long startTime) {
        this.broadCastMessageWithSound(Lang.ATTACK_START_NOW.get(this.name), SoundEnum.WAR);
        CurrentAttacksStorage.startAttack(this, startTime, this.endTime);
    }

    public void addDefender(TerritoryData territory) {
        this.defendersID.add(territory.getID());
    }

    public void addAttacker(TerritoryData territoryData) {
        this.attackersID.add(territoryData.getID());
    }

    public ItemStack getAdminIcon(LangType langType) {
        long startDate = this.startTime - new Date().getTime() / 50L;
        long attackDuration = this.endTime - this.startTime;
        ItemStack itemStack = new ItemStack(Material.IRON_SWORD);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.name);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Lang.ATTACK_ICON_DESC_1.get(langType, this.war.getMainAttacker().getName()));
            lore.add(Lang.ATTACK_ICON_DESC_2.get(langType, this.war.getMainDefender().getName()));
            lore.add(Lang.ATTACK_ICON_DESC_3.get(langType, Integer.toString(this.getNumberOfAttackers())));
            lore.add(Lang.ATTACK_ICON_DESC_4.get(langType, Integer.toString(this.getNumberOfDefenders())));
            lore.add(Lang.ATTACK_ICON_DESC_6.get(langType, DateUtil.getDateStringFromTicks(startDate)));
            lore.add(Lang.ATTACK_ICON_DESC_7.get(langType, DateUtil.getDateStringFromTicks(attackDuration)));
            if (this.isAdminApproved) {
                lore.add(Lang.ATTACK_ICON_DESC_ADMIN_APPROVED.get(langType, new String[0]));
            } else {
                lore.add(Lang.ATTACK_ICON_DESC_ADMIN_NOT_APPROVED.get(langType, new String[0]));
                lore.add(Lang.LEFT_CLICK_TO_AUTHORIZE.get(langType, new String[0]));
                lore.add(Lang.GUI_GENERIC_RIGHT_CLICK_TO_DELETE.get(langType, new String[0]));
                lore.add(Lang.ATTACK_WILL_NOT_TRIGGER_IF_NOT_APPROVED.get(langType, new String[0]));
            }
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack getIcon(ITanPlayer tanPlayer, TerritoryData territoryConcerned) {
        long startDate = this.startTime - new Date().getTime() / 50L;
        long attackDuration = this.endTime - this.startTime;
        String exactTimeStart = TimeZoneManager.getInstance().formatDateForPlayer(tanPlayer, Instant.ofEpochSecond(this.startTime / 20L));
        LangType langType = tanPlayer.getLang();
        ItemStack itemStack = new ItemStack(Material.IRON_SWORD);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.name);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Lang.ATTACK_ICON_DESC_1.get(langType, this.war.getMainAttacker().getName()));
            lore.add(Lang.ATTACK_ICON_DESC_2.get(langType, this.war.getMainDefender().getName()));
            lore.add(Lang.ATTACK_ICON_DESC_3.get(langType, Integer.toString(this.getNumberOfAttackers())));
            lore.add(Lang.ATTACK_ICON_DESC_4.get(langType, Integer.toString(this.getNumberOfDefenders())));
            lore.add(Lang.ATTACK_ICON_DESC_6.get(langType, DateUtil.getDateStringFromTicks(startDate), exactTimeStart));
            lore.add(Lang.ATTACK_ICON_DESC_7.get(langType, DateUtil.getDateStringFromTicks(attackDuration)));
            lore.add(Lang.ATTACK_ICON_DESC_8.get(langType, this.getTerritoryRole(territoryConcerned).getName(langType)));
            lore.add(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(langType, new String[0]));
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private int getNumberOfAttackers() {
        return this.attackersID.size();
    }

    private int getNumberOfDefenders() {
        return this.defendersID.size();
    }

    public void end() {
        if (this.warStartTask != null) {
            this.warStartTask.cancel();
        }
        if (this.warWarningTask != null) {
            this.warWarningTask.cancel();
        }
        CaptureManager.getInstance().removeCapture(this);
        CurrentAttack currentAttack = CurrentAttacksStorage.get(this.ID);
        if (currentAttack != null) {
            currentAttack.end();
        }
        for (TerritoryData territory : this.getAttackingTerritories()) {
            territory.removePlannedAttack(this);
        }
        for (TerritoryData territory : this.getDefendingTerritories()) {
            territory.removePlannedAttack(this);
        }
        PlannedAttackStorage.getInstance().delete(this);
    }

    private boolean isSecondaryAttacker(TerritoryData territoryConcerned) {
        return this.attackersID.contains(territoryConcerned.getID());
    }

    private boolean isSecondaryDefender(TerritoryData territoryConcerned) {
        return this.defendersID.contains(territoryConcerned.getID());
    }

    public WarRole getRole(ITanPlayer player) {
        for (TerritoryData territoryData : player.getAllTerritoriesPlayerIsIn()) {
            WarRole role = this.getTerritoryRole(territoryData);
            if (role == WarRole.NEUTRAL) continue;
            return role;
        }
        return WarRole.NEUTRAL;
    }

    public WarRole getTerritoryRole(TerritoryData territory) {
        if (this.war.isMainAttacker(territory)) {
            return WarRole.MAIN_ATTACKER;
        }
        if (this.war.isMainDefender(territory)) {
            return WarRole.MAIN_DEFENDER;
        }
        if (this.isSecondaryAttacker(territory)) {
            return WarRole.OTHER_ATTACKER;
        }
        if (this.isSecondaryDefender(territory)) {
            return WarRole.OTHER_DEFENDER;
        }
        return WarRole.NEUTRAL;
    }

    public void removeBelligerent(TerritoryData territory) {
        String territoryID = territory.getID();
        this.attackersID.remove(territoryID);
        this.defendersID.remove(territoryID);
    }

    public void territorySurrendered() {
        EventManager.getInstance().callEvent(new DefenderAcceptDemandsBeforeWarInternalEvent(this.war.getMainDefender(), this.war.getMainAttacker()));
        this.war.territorySurrender(this.warRole);
        this.end();
    }

    public ItemStack getAttackingIcon(LangType langType) {
        ItemStack itemStack = new ItemStack(Material.IRON_HELMET);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.setDisplayName(Lang.GUI_ATTACKING_SIDE_ICON.get(langType, new String[0]));
        lore.add(Lang.GUI_ATTACKING_SIDE_ICON_DESC1.get(langType, new String[0]));
        for (TerritoryData territoryData : this.getAttackingTerritories()) {
            lore.add(Lang.GUI_ICON_LIST.get(langType, territoryData.getBaseColoredName()));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack getDefendingIcon(LangType langType) {
        ItemStack itemStack = new ItemStack(Material.DIAMOND_HELMET);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.setDisplayName(Lang.GUI_DEFENDING_SIDE_ICON.get(langType, new String[0]));
        lore.add(Lang.GUI_DEFENDING_SIDE_ICON_DESC1.get(langType, new String[0]));
        for (TerritoryData territoryData : this.getDefendingTerritories()) {
            lore.add(Lang.GUI_ICON_LIST.get(langType, territoryData.getBaseColoredName()));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public void rename(String message) {
        this.name = message;
    }

    public List<OfflinePlayer> getAllOfflinePlayers() {
        ArrayList<ITanPlayer> res = new ArrayList<ITanPlayer>(this.getDefendingPlayers());
        res.addAll(this.getAttackersPlayers());
        return res.stream().map(ITanPlayer::getOfflinePlayer).filter(Objects::nonNull).toList();
    }

    public List<Player> getAllOnlinePlayers() {
        return this.getAllOfflinePlayers().stream().map(OfflinePlayer::getPlayer).filter(Objects::nonNull).toList();
    }
}

