/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.cosmetic;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.position.CardinalPoint;
import org.leralix.lib.position.Vector2D;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.particles.ParticleUtils;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.territory.ChunkUtil;
import org.leralix.tan.war.cosmetic.ChunkLine;
import org.leralix.tan.war.legacy.CurrentAttack;

public class ShowBoundaries {
    public static void display(Player player) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        List<CurrentAttack> attacks = tanPlayer.getCurrentAttacks();
        if (attacks.isEmpty()) {
            return;
        }
        double radius = Constants.getWarBoundaryRadius();
        List<ClaimedChunk2> chunkInRange = ChunkUtil.getChunksInRadius(player.getChunk(), radius);
        List<ChunkLine> lines = ShowBoundaries.sortChunkLines(chunkInRange, attacks);
        ShowBoundaries.drawLines(player, lines);
    }

    static void drawLines(Player player, List<ChunkLine> lines) {
        int y = (int)player.getLocation().getY() + 1;
        for (ChunkLine line : lines) {
            ParticleUtils.drawPane((Plugin)TownsAndNations.getPlugin(), (Player)player, (Vector3D)new Vector3D(line.getPoint1().getX(), y, line.getPoint1().getZ(), line.getPoint1().getWorldID().toString()), (Vector3D)new Vector3D(line.getPoint2().getX(), y - 1, line.getPoint2().getZ(), line.getPoint2().getWorldID().toString()), (int)1, (Particle)Constants.getWarBoundaryParticle());
        }
    }

    static List<ChunkLine> sortChunkLines(List<ClaimedChunk2> chunkInRange, List<CurrentAttack> attacks) {
        ArrayList<ChunkLine> res = new ArrayList<ChunkLine>();
        for (ClaimedChunk2 centerChunk : chunkInRange) {
            ClaimedChunk2 westChunk;
            ClaimedChunk2 eastChunk;
            ClaimedChunk2 southChunk;
            if (!(centerChunk instanceof TerritoryChunk)) continue;
            TerritoryChunk territoryChunk = (TerritoryChunk)centerChunk;
            Vector2D centerChunkPosition = centerChunk.getVector2D();
            ClaimedChunk2 northChunk = NewClaimedChunkStorage.getInstance().get(centerChunkPosition.getX(), centerChunkPosition.getZ() - 1, centerChunkPosition.getWorldID().toString());
            if (ShowBoundaries.isFrontline(territoryChunk, northChunk, attacks)) {
                res.add(ShowBoundaries.getChunkLine(centerChunkPosition, CardinalPoint.NORTH));
            }
            if (ShowBoundaries.isFrontline(territoryChunk, southChunk = NewClaimedChunkStorage.getInstance().get(centerChunkPosition.getX(), centerChunkPosition.getZ() + 1, centerChunkPosition.getWorldID().toString()), attacks)) {
                res.add(ShowBoundaries.getChunkLine(centerChunkPosition, CardinalPoint.SOUTH));
            }
            if (ShowBoundaries.isFrontline(territoryChunk, eastChunk = NewClaimedChunkStorage.getInstance().get(centerChunkPosition.getX() + 1, centerChunkPosition.getZ(), centerChunkPosition.getWorldID().toString()), attacks)) {
                res.add(ShowBoundaries.getChunkLine(centerChunkPosition, CardinalPoint.EAST));
            }
            if (!ShowBoundaries.isFrontline(territoryChunk, westChunk = NewClaimedChunkStorage.getInstance().get(centerChunkPosition.getX() - 1, centerChunkPosition.getZ(), centerChunkPosition.getWorldID().toString()), attacks)) continue;
            res.add(ShowBoundaries.getChunkLine(centerChunkPosition, CardinalPoint.WEST));
        }
        return res;
    }

    static ChunkLine getChunkLine(Vector2D centerChunk, CardinalPoint dir) {
        Vector2D start;
        int baseX = centerChunk.getX() * 16;
        int baseZ = centerChunk.getZ() * 16;
        String worldID = centerChunk.getWorldID().toString();
        return new ChunkLine(start, switch (dir) {
            case CardinalPoint.NORTH -> {
                start = new Vector2D(baseX, baseZ, worldID);
                yield new Vector2D(baseX + 16, baseZ, worldID);
            }
            case CardinalPoint.SOUTH -> {
                start = new Vector2D(baseX, baseZ + 16, worldID);
                yield new Vector2D(baseX + 16, baseZ + 16, worldID);
            }
            case CardinalPoint.EAST -> {
                start = new Vector2D(baseX + 16, baseZ, worldID);
                yield new Vector2D(baseX + 16, baseZ + 16, worldID);
            }
            case CardinalPoint.WEST -> {
                start = new Vector2D(baseX, baseZ, worldID);
                yield new Vector2D(baseX, baseZ + 16, worldID);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(dir));
        });
    }

    private static boolean isFrontline(TerritoryChunk centerChunk, ClaimedChunk2 chunkToCompare, List<CurrentAttack> attacks) {
        if (chunkToCompare == null) {
            return false;
        }
        TerritoryData occupier = centerChunk.getOccupier();
        for (CurrentAttack attackData : attacks) {
            TerritoryChunk territoryChunk;
            if (!attackData.getAttackData().getWar().isMainDefender(occupier)) continue;
            return !(chunkToCompare instanceof TerritoryChunk) || !(territoryChunk = (TerritoryChunk)chunkToCompare).getOccupierID().equals(occupier.getID());
        }
        return false;
    }
}

