/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.fort;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.building.Building;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.FortStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.gameplay.TANCustomNBT;

public abstract class Fort
extends Building {
    protected Fort() {
    }

    public void updateFlag() {
        Vector3D flagPosition = this.getPosition();
        Block flagBlock = flagPosition.getLocation().add(0.0, 1.0, 0.0).getBlock();
        if (this.isOccupied()) {
            flagBlock.setType(Material.RED_BANNER);
        }
        if (!this.isOccupied()) {
            flagBlock.setType(Material.GREEN_BANNER);
        }
    }

    public void spawnFlag() {
        Vector3D flagPosition = this.getPosition();
        Block flagBlock = flagPosition.getLocation().add(0.0, 1.0, 0.0).getBlock();
        flagBlock.setType(Material.GREEN_BANNER);
        this.setProtectedBlockData();
    }

    public abstract String getID();

    @Override
    public abstract Vector3D getPosition();

    public abstract TerritoryData getOwner();

    public abstract TerritoryData getOccupier();

    public abstract String getName();

    public abstract int getCaptureProgress();

    protected abstract void setOccupierInternal(TerritoryData var1);

    public void setOccupier(TerritoryData newOwner) {
        newOwner.addOccupiedFort(this);
        this.setOccupierInternal(newOwner);
    }

    public void liberate() {
        this.getOccupier().removeOccupiedFort(this);
        this.setOccupierInternal(this.getOwner());
    }

    public abstract void setCaptureProgress(int var1);

    public boolean isOccupied() {
        return !this.getOwner().getID().equals(this.getOccupier().getID());
    }

    @Override
    public GuiItem getGuiItem(IconManager iconManager, Player player, TerritoryData territoryData, BasicGui basicGui) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Vector3D position = this.getPosition();
        return iconManager.get(IconKey.FORT_BUILDING_ICON).setName(this.getName()).setDescription(Lang.FORT_OCCUPIED_BY.get(langType, this.getOccupier().getColoredName()), Lang.DISPLAY_COORDINATES.get(langType, Integer.toString(position.getX()), Integer.toString(position.getY()), Integer.toString(position.getZ())), Lang.GUI_GENERIC_RIGHT_CLICK_TO_DELETE.get(langType, new String[0])).setAction(action -> {
            if (action.isRightClick()) {
                FortStorage.getInstance().delete(this);
                SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
                basicGui.open();
            }
        }).asGuiItem(player);
    }

    private void deleteFlag() {
        Vector3D flagPosition = this.getPosition();
        Block baseBlock = flagPosition.getLocation().getBlock();
        Block flagBlock = flagPosition.getLocation().add(0.0, 1.0, 0.0).getBlock();
        flagBlock.setType(Material.AIR);
        TANCustomNBT.removeBockMetaData(baseBlock, "fortFlag");
        TANCustomNBT.removeBockMetaData(flagBlock, "fortFlag");
    }

    public void delete() {
        this.getOccupier().removeOwnedFort(this);
        this.deleteFlag();
    }

    public abstract void setOwner(TerritoryData var1);

    public void setProtectedBlockData() {
        Vector3D flagPosition = this.getPosition();
        Block baseBlock = flagPosition.getLocation().getBlock();
        Block flagBlock = flagPosition.getLocation().add(0.0, 1.0, 0.0).getBlock();
        TANCustomNBT.setBockMetaData(baseBlock, "fortFlag", this.getID());
        TANCustomNBT.setBockMetaData(flagBlock, "fortFlag", this.getID());
    }
}

