/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.fort;

import org.leralix.lib.position.Vector3D;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.war.fort.Fort;

public class FortData
extends Fort {
    private final String id;
    private final Vector3D position;
    private String name;
    private String ownerID;
    private String occupierID;
    private int captureProgress;

    public FortData(String id, Vector3D position, String name, TerritoryData owningTerritory) {
        this.id = id;
        this.position = position;
        this.name = name;
        this.ownerID = owningTerritory.getID();
        this.occupierID = owningTerritory.getID();
        this.spawnFlag();
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public TerritoryData getOwner() {
        return TerritoryUtil.getTerritory(this.ownerID);
    }

    @Override
    public TerritoryData getOccupier() {
        return TerritoryUtil.getTerritory(this.occupierID);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setOccupierInternal(TerritoryData newOwner) {
        this.occupierID = newOwner.getID();
    }

    @Override
    public int getCaptureProgress() {
        return this.captureProgress;
    }

    @Override
    public void setCaptureProgress(int value) {
        this.captureProgress = value;
    }

    @Override
    public void setOwner(TerritoryData newOwner) {
        this.ownerID = newOwner.getID();
    }
}

