/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.legacy;

import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;

public class CreateAttackData {
    private final int minTime = Constants.getMinTimeBeforeAttack();
    private final int maxTime = Constants.getMaxTimeBeforeAttack();
    private int selectedTime = (this.minTime + this.maxTime) / 2;
    private final War war;
    private final WarRole attackingSide;

    public CreateAttackData(War war, WarRole attackingSide) {
        this.war = war;
        this.attackingSide = attackingSide;
    }

    public void addDeltaDateTime(int deltaDateTime) {
        this.selectedTime += deltaDateTime;
        if (this.selectedTime < this.minTime) {
            this.selectedTime = this.minTime;
        }
        if (this.selectedTime > this.maxTime) {
            this.selectedTime = this.maxTime;
        }
    }

    public int getSelectedTime() {
        return this.selectedTime;
    }

    public War getWar() {
        return this.war;
    }

    public WarRole getAttackingSide() {
        return this.attackingSide;
    }
}

