/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.protocol.a;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.leralix.shadow.mysql.cj.BindValue;
import org.leralix.shadow.mysql.cj.conf.PropertyKey;
import org.leralix.shadow.mysql.cj.exceptions.CJOperationNotSupportedException;
import org.leralix.shadow.mysql.cj.exceptions.ExceptionFactory;
import org.leralix.shadow.mysql.cj.exceptions.WrongArgumentException;
import org.leralix.shadow.mysql.cj.protocol.Message;
import org.leralix.shadow.mysql.cj.protocol.a.AbstractValueEncoder;
import org.leralix.shadow.mysql.cj.util.StringUtils;
import org.leralix.shadow.mysql.cj.util.Util;

public class ReaderValueEncoder
extends AbstractValueEncoder {
    @Override
    public byte[] getBytes(BindValue binding) {
        return this.readBytes((Reader)binding.getValue(), binding);
    }

    @Override
    public String getString(BindValue binding) {
        return "'** STREAM DATA **'";
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    protected byte[] readBytes(Reader reader, BindValue binding) {
        try {
            byte[] bytes;
            String clobEncoding;
            char[] c = null;
            int len = 0;
            boolean useLength = this.propertySet.getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts).getValue();
            String string = clobEncoding = binding.isNational() ? null : this.propertySet.getStringProperty(PropertyKey.clobCharacterEncoding).getStringValue();
            if (clobEncoding == null) {
                clobEncoding = this.charEncoding.getStringValue();
            }
            long scaleOrLength = binding.getScaleOrLength();
            if (useLength && scaleOrLength != -1L) {
                c = new char[(int)scaleOrLength];
                int numCharsRead = Util.readFully(reader, c, (int)scaleOrLength);
                bytes = StringUtils.getBytes(new String(c, 0, numCharsRead), clobEncoding);
            } else {
                c = new char[4096];
                StringBuilder buf = new StringBuilder();
                while ((len = reader.read(c)) != -1) {
                    buf.append(c, 0, len);
                }
                bytes = StringUtils.getBytes(buf.toString(), clobEncoding);
            }
            return this.escapeBytesIfNeeded(bytes);
        }
        catch (UnsupportedEncodingException uec) {
            throw ExceptionFactory.createException(WrongArgumentException.class, uec.toString(), uec, this.exceptionInterceptor);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createException(ioEx.toString(), ioEx, this.exceptionInterceptor);
        }
    }
}

