/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.result;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.leralix.shadow.mysql.cj.Messages;
import org.leralix.shadow.mysql.cj.conf.PropertyKey;
import org.leralix.shadow.mysql.cj.conf.PropertySet;
import org.leralix.shadow.mysql.cj.exceptions.DataConversionException;
import org.leralix.shadow.mysql.cj.protocol.InternalDate;
import org.leralix.shadow.mysql.cj.protocol.InternalTime;
import org.leralix.shadow.mysql.cj.protocol.InternalTimestamp;
import org.leralix.shadow.mysql.cj.result.ValueFactory;

public abstract class DefaultValueFactory<T>
implements ValueFactory<T> {
    protected boolean jdbcCompliantTruncationForReads = true;
    protected PropertySet pset = null;

    public DefaultValueFactory(PropertySet pset) {
        this.pset = pset;
        this.jdbcCompliantTruncationForReads = this.pset.getBooleanProperty(PropertyKey.jdbcCompliantTruncation).getInitialValue();
    }

    @Override
    public void setPropertySet(PropertySet pset) {
        this.pset = pset;
    }

    protected T unsupported(String sourceType) {
        throw new DataConversionException(Messages.getString("ResultSet.UnsupportedConversion", new Object[]{sourceType, this.getTargetTypeName()}));
    }

    @Override
    public T createFromDate(InternalDate idate) {
        return this.unsupported("DATE");
    }

    @Override
    public T createFromTime(InternalTime it) {
        return this.unsupported("TIME");
    }

    @Override
    public T createFromTimestamp(InternalTimestamp its) {
        return this.unsupported("TIMESTAMP");
    }

    @Override
    public T createFromDatetime(InternalTimestamp its) {
        return this.unsupported("DATETIME");
    }

    @Override
    public T createFromLong(long l) {
        return this.unsupported("LONG");
    }

    @Override
    public T createFromBigInteger(BigInteger i) {
        return this.unsupported("BIGINT");
    }

    @Override
    public T createFromDouble(double d) {
        return this.unsupported("DOUBLE");
    }

    @Override
    public T createFromBigDecimal(BigDecimal d) {
        return this.unsupported("DECIMAL");
    }

    @Override
    public T createFromBit(byte[] bytes, int offset, int length) {
        return this.unsupported("BIT");
    }

    @Override
    public T createFromYear(long l) {
        return this.unsupported("YEAR");
    }

    @Override
    public T createFromNull() {
        return null;
    }
}

