/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.external.papi.entries;

import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.api.external.papi.entries.PapiEntry;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;

public class TerritoryWithNameLeaderName
extends PapiEntry {
    public TerritoryWithNameLeaderName() {
        super("territory_with_id_{}_leader_name");
    }

    @Override
    public String getData(OfflinePlayer player, @NotNull String params) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player.getUniqueId());
        if (tanPlayer == null) {
            return "[TAN] Player data not found";
        }
        String[] values = TerritoryWithNameLeaderName.extractValues(params);
        if (values.length == 0) {
            return Lang.INVALID_VALUE.get(tanPlayer);
        }
        String id = values[0];
        if (id == null) {
            return Lang.INVALID_ID.get(tanPlayer);
        }
        TerritoryData territoryData = (TerritoryData)TownDataStorage.getInstance().get(id);
        if (territoryData == null) {
            territoryData = (TerritoryData)RegionDataStorage.getInstance().get(id);
        }
        if (territoryData == null) {
            return Lang.INVALID_TERRITORY.get(tanPlayer);
        }
        return territoryData.getLeaderData().getOfflinePlayer().getName();
    }
}

