/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.external.worldguard;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.leralix.tan.api.external.worldguard.WorldGuardImplementation;
import org.leralix.tan.enums.permissions.ChunkPermissionType;

public class WorldGuardManager {
    private WorldGuardImplementation implementation;
    private static WorldGuardManager instance;

    private WorldGuardManager() {
    }

    public static WorldGuardManager getInstance() {
        if (instance == null) {
            instance = new WorldGuardManager();
        }
        return instance;
    }

    public void register() {
        this.implementation = new WorldGuardImplementation();
    }

    public boolean isEnabled() {
        return this.implementation != null;
    }

    public boolean isHandledByWorldGuard(Location location) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.implementation.isHandledByWorldGuard(location);
    }

    public boolean isActionAllowed(Player player, Location location, ChunkPermissionType actionType) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.implementation.isActionAllowed(player, location, actionType);
    }
}

