/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.internal.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.leralix.tan.api.internal.wrappers.PropertyDataWrapper;
import org.leralix.tan.api.internal.wrappers.RegionDataWrapper;
import org.leralix.tan.api.internal.wrappers.TownDataWrapper;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.tan.api.interfaces.TanPlayer;
import org.tan.api.interfaces.TanProperty;
import org.tan.api.interfaces.TanRegion;
import org.tan.api.interfaces.TanTown;

public class TanPlayerWrapper
implements TanPlayer {
    private final ITanPlayer tanPlayer;

    private TanPlayerWrapper(ITanPlayer tanPlayer) {
        this.tanPlayer = tanPlayer;
    }

    public static TanPlayer of(ITanPlayer tanPlayer) {
        if (tanPlayer == null) {
            return null;
        }
        return new TanPlayerWrapper(tanPlayer);
    }

    @Override
    public String getNameStored() {
        return this.tanPlayer.getNameStored();
    }

    @Override
    public void setNameStored(String s) {
        this.tanPlayer.setNameStored(s);
    }

    @Override
    public UUID getUUID() {
        return this.tanPlayer.getUUID();
    }

    @Override
    public boolean hasTown() {
        return this.tanPlayer.hasTown();
    }

    @Override
    public Optional<TanTown> getTown() {
        return Optional.ofNullable(TownDataWrapper.of(this.tanPlayer.getTown()));
    }

    @Override
    public boolean hasRegion() {
        return this.tanPlayer.hasRegion();
    }

    @Override
    public TanRegion getRegion() {
        return RegionDataWrapper.of(this.tanPlayer.getRegion());
    }

    @Override
    public Collection<TanProperty> getPropertiesOwned() {
        return this.tanPlayer.getProperties().stream().map(PropertyDataWrapper::of).map(p -> p).toList();
    }

    @Override
    public Collection<TanProperty> getPropertiesRented() {
        ArrayList<TanProperty> properties = new ArrayList<TanProperty>();
        for (TownData town : TownDataStorage.getInstance().getAll().values()) {
            for (PropertyData property : town.getProperties()) {
                ITanPlayer renter = property.getRenter();
                if (renter == null || !this.getUUID().equals(renter.getUUID())) continue;
                properties.add(PropertyDataWrapper.of(property));
            }
        }
        return properties;
    }

    @Override
    public Collection<TanProperty> getPropertiesForSale() {
        ArrayList<TanProperty> properties = new ArrayList<TanProperty>();
        for (TownData town : TownDataStorage.getInstance().getAll().values()) {
            for (PropertyData property : town.getProperties()) {
                ITanPlayer owner = property.getOwner();
                if (!this.getUUID().equals(owner.getUUID()) || !property.isForSale()) continue;
                properties.add(PropertyDataWrapper.of(property));
            }
        }
        return properties;
    }
}

