/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.internal.wrappers;

import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.api.internal.wrappers.ClaimedChunkWrapper;
import org.leralix.tan.api.internal.wrappers.TanPlayerWrapper;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.tan.api.enums.ETownPermission;
import org.tan.api.interfaces.TanClaimedChunk;
import org.tan.api.interfaces.TanPlayer;
import org.tan.api.interfaces.TanTerritory;

public class TerritoryDataWrapper
implements TanTerritory {
    private final TerritoryData territoryData;

    protected TerritoryDataWrapper(TerritoryData territoryData) {
        this.territoryData = territoryData;
    }

    public static TanTerritory of(TerritoryData territoryData) {
        if (territoryData == null) {
            return null;
        }
        return new TerritoryDataWrapper(territoryData);
    }

    @Override
    public String getID() {
        return this.territoryData.getID();
    }

    @Override
    public String getName() {
        return this.territoryData.getName();
    }

    @Override
    public void setName(String newName) {
        this.territoryData.rename(newName);
    }

    @Override
    public String getDescription() {
        return this.territoryData.getDescription();
    }

    @Override
    public void setDescription(String s) {
        this.territoryData.setDescription(s);
    }

    @Override
    public TanPlayer getOwner() {
        return TanPlayerWrapper.of(this.territoryData.getLeaderData());
    }

    @Override
    public UUID getOwnerUUID() {
        return this.getOwner().getUUID();
    }

    @Override
    public Long getCreationDate() {
        return this.territoryData.getCreationDate();
    }

    @Override
    public ItemStack getIcon() {
        return this.territoryData.getIcon();
    }

    @Override
    public Color getColor() {
        return Color.fromRGB((int)this.territoryData.getChunkColorCode());
    }

    @Override
    public void setColor(Color color) {
        this.territoryData.setChunkColor(color.asRGB());
    }

    @Override
    public int getNumberOfClaimedChunk() {
        return this.getClaimedChunks().size();
    }

    @Override
    public Collection<TanPlayer> getMembers() {
        return this.territoryData.getITanPlayerList().stream().map(TanPlayerWrapper::of).toList();
    }

    @Override
    public Collection<TanTerritory> getVassals() {
        return this.territoryData.getVassals().stream().map(TerritoryDataWrapper::of).toList();
    }

    @Override
    public boolean haveOverlord() {
        return this.territoryData.haveOverlord();
    }

    @Override
    public TanTerritory getOverlord() {
        return TerritoryDataWrapper.of(this.territoryData.getOverlord().get());
    }

    @Override
    public boolean canPlayerDoAction(TanPlayer tanPlayer, ETownPermission permission) {
        Player player = Bukkit.getPlayer((UUID)tanPlayer.getUUID());
        if (player == null) {
            return false;
        }
        RolePermission playerPermission = RolePermission.valueOf(permission.name());
        return this.territoryData.doesPlayerHavePermission(player, playerPermission);
    }

    @Override
    public Collection<TanClaimedChunk> getClaimedChunks() {
        return NewClaimedChunkStorage.getInstance().getAllChunkFrom(this.territoryData).stream().map(ClaimedChunkWrapper::of).toList();
    }
}

