/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.admin;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.commands.SubCommand;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.lang.DynamicLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.ClaimBlacklistStorage;
import org.leralix.tan.storage.MobChunkSpawnStorage;
import org.leralix.tan.storage.WildernessRules;
import org.leralix.tan.storage.legacy.UpgradeStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.constants.EnabledPermissions;
import org.leralix.tan.utils.text.NumberUtil;

public class ReloadCommand
extends SubCommand {
    public String getName() {
        return "reload";
    }

    public String getDescription() {
        return Lang.ADMIN_RELOAD_COMMAND.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tanadmin reload";
    }

    public List<String> getTabCompleteSuggestions(CommandSender player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(CommandSender commandSender, String[] args) {
        if (args.length == 1) {
            TownsAndNations plugin = TownsAndNations.getPlugin();
            ConfigUtil.addCustomConfig((Plugin)plugin, (String)"config.yml", (ConfigTag)ConfigTag.MAIN);
            ConfigUtil.addCustomConfig((Plugin)plugin, (String)"townUpgrades.yml", (ConfigTag)ConfigTag.UPGRADE);
            ConfigUtil.addCustomConfig((Plugin)plugin, (String)"lang.yml", (ConfigTag)ConfigTag.LANG);
            String lang = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.LANG).getString("language");
            File langFolder = new File(TownsAndNations.getPlugin().getDataFolder(), "lang");
            Lang.loadTranslations(langFolder, lang);
            DynamicLang.loadTranslations(langFolder, lang);
            Constants.init();
            UpgradeStorage.init();
            MobChunkSpawnStorage.init();
            ClaimBlacklistStorage.init();
            WildernessRules.getInstance().init();
            NumberUtil.init();
            EnabledPermissions.getInstance().init();
            commandSender.sendMessage(Lang.RELOAD_SUCCESS.getDefault());
            commandSender.sendMessage(Lang.LANGUAGE_SUCCESSFULLY_LOADED.getDefault());
        } else {
            commandSender.sendMessage(Lang.TOO_MANY_ARGS_ERROR.getDefault());
            commandSender.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(this.getSyntax()).getDefault());
        }
    }
}

