/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.admin;

import java.util.Collections;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.RegionClaimedChunk;
import org.leralix.tan.dataclass.chunk.TownClaimedChunk;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;

public class UnclaimAdminCommand
extends PlayerSubCommand {
    public String getName() {
        return "unclaim";
    }

    public String getDescription() {
        return Lang.ADMIN_UNCLAIM_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tanadmin unclaim";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(Player player, String[] args) {
        if (args.length != 1) {
            player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(player));
            return;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (!NewClaimedChunkStorage.getInstance().isChunkClaimed(chunk)) {
            player.sendMessage(Lang.ADMIN_UNCLAIM_CHUNK_NOT_CLAIMED.get(player));
            return;
        }
        ClaimedChunk2 claimedChunk = NewClaimedChunkStorage.getInstance().get(chunk);
        if (claimedChunk instanceof TownClaimedChunk) {
            TownClaimedChunk townClaimedChunk = (TownClaimedChunk)claimedChunk;
            this.unclaimChunkTown(player, townClaimedChunk);
        } else if (claimedChunk instanceof RegionClaimedChunk) {
            RegionClaimedChunk regionClaimedChunk = (RegionClaimedChunk)claimedChunk;
            this.unclaimChunkRegion(player, regionClaimedChunk);
        }
    }

    private void unclaimChunkTown(Player player, TownClaimedChunk claimedChunk) {
        TownData townData = claimedChunk.getTown();
        NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(claimedChunk);
        player.sendMessage(Lang.DEBUG_UNCLAIMED_CHUNK_SUCCESS_TOWN.get(player, townData.getName(), Integer.toString(townData.getNumberOfClaimedChunk()), Integer.toString(townData.getLevel().getChunkCap())));
    }

    private void unclaimChunkRegion(Player player, RegionClaimedChunk claimedChunk) {
        RegionData regionData = claimedChunk.getRegion();
        NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(claimedChunk);
        player.sendMessage(Lang.DEBUG_UNCLAIMED_CHUNK_SUCCESS_REGION.get(player, regionData.getName(), Integer.toString(regionData.getNumberOfClaimedChunk())));
    }
}

