/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.ChatScope;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.LocalChatStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public class ChannelChatScopeCommand
extends PlayerSubCommand {
    private static final String TOWN = "town";
    private static final String ALLIANCE = "alliance";
    private static final String REGION = "region";
    private static final String GLOBAL = "global";

    public String getName() {
        return "chat";
    }

    public String getDescription() {
        return Lang.TOWN_CHAT_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan chat <global|alliance|region|town> [message]";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 2) {
            suggestions.add(TOWN);
            suggestions.add(ALLIANCE);
            suggestions.add(REGION);
            suggestions.add(GLOBAL);
        }
        return suggestions;
    }

    public void perform(Player player, String[] args) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        if (args.length == 1) {
            player.sendMessage(Lang.NOT_ENOUGH_ARGS_ERROR.get(langType, new String[0]));
            player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
        } else if (args.length == 2) {
            ChannelChatScopeCommand.registerPlayerToScope(player, args[1]);
        } else if (args.length >= 3) {
            this.sendSingleMessage(player, args[1], args);
        } else {
            player.sendMessage(Lang.TOO_MANY_ARGS_ERROR.get(langType, new String[0]));
            player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
        }
    }

    private static void registerPlayerToScope(Player player, String channelName) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        LangType langType = tanPlayer.getLang();
        TownData town = tanPlayer.getTown();
        if (town == null) {
            player.sendMessage(Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
            return;
        }
        if (channelName.equalsIgnoreCase(GLOBAL)) {
            LocalChatStorage.removePlayerChatScope(player);
            player.sendMessage(Lang.CHAT_CHANGED.get(langType, channelName));
            return;
        }
        ChatScope scope = LocalChatStorage.getPlayerChatScope(player);
        if (channelName.equalsIgnoreCase(TOWN)) {
            if (scope == ChatScope.CITY) {
                player.sendMessage(Lang.TOWN_CHAT_ALREADY_IN_CHAT.get(langType, ChatScope.CITY.getName(langType)));
                return;
            }
            LocalChatStorage.setPlayerChatScope(player, ChatScope.CITY);
            player.sendMessage(Lang.CHAT_CHANGED.get(langType, channelName));
            return;
        }
        if (channelName.equalsIgnoreCase(ALLIANCE)) {
            if (scope == ChatScope.ALLIANCE) {
                player.sendMessage(Lang.TOWN_CHAT_ALREADY_IN_CHAT.get(langType, ChatScope.ALLIANCE.getName(langType)));
                return;
            }
            LocalChatStorage.setPlayerChatScope(player, ChatScope.ALLIANCE);
            player.sendMessage(Lang.CHAT_CHANGED.get(langType, channelName));
            return;
        }
        if (channelName.equalsIgnoreCase(REGION)) {
            if (scope == ChatScope.REGION) {
                player.sendMessage(Lang.TOWN_CHAT_ALREADY_IN_CHAT.get(langType, ChatScope.REGION.getName(langType)));
                return;
            }
            LocalChatStorage.setPlayerChatScope(player, ChatScope.REGION);
            player.sendMessage(Lang.CHAT_CHANGED.get(langType, channelName));
            return;
        }
        player.sendMessage(Lang.CHAT_SCOPE_NOT_FOUND.get(langType, channelName));
    }

    private void sendSingleMessage(Player player, String channelName, String[] words) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        LangType langType = tanPlayer.getLang();
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(words, 2, words.length));
        switch (channelName.toLowerCase()) {
            case "global": {
                if (LocalChatStorage.isPlayerInChatScope(player.getUniqueId().toString())) {
                    ChatScope prevScope = LocalChatStorage.getPlayerChatScope(player);
                    LocalChatStorage.removePlayerChatScope(player);
                    player.chat(message);
                    LocalChatStorage.setPlayerChatScope(player, prevScope);
                } else {
                    player.chat(message);
                }
                return;
            }
            case "alliance": {
                if (!tanPlayer.hasTown()) {
                    player.sendMessage(Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
                    return;
                }
                TownData playerTown = tanPlayer.getTown();
                playerTown.getRelations().getTerritoriesIDWithRelation(TownRelation.ALLIANCE).forEach(territoryID -> Objects.requireNonNull(TerritoryUtil.getTerritory(territoryID)).broadCastMessage(Lang.CHAT_SCOPE_ALLIANCE_MESSAGE.get(playerTown.getName(), player.getName(), message)));
                return;
            }
            case "region": {
                if (!tanPlayer.hasRegion()) {
                    player.sendMessage(Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
                    return;
                }
                RegionData regionData = tanPlayer.getRegion();
                if (regionData != null) {
                    regionData.broadCastMessage(Lang.CHAT_SCOPE_REGION_MESSAGE.get(regionData.getName(), player.getName(), message));
                }
                return;
            }
            case "town": {
                if (!tanPlayer.hasTown()) {
                    player.sendMessage(Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
                    return;
                }
                TownData townData = tanPlayer.getTown();
                if (townData != null) {
                    townData.broadCastMessage(Lang.CHAT_SCOPE_TOWN_MESSAGE.get(townData.getName(), player.getName(), message));
                }
                return;
            }
        }
        player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
    }
}

