/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.enums.ClaimAction;
import org.leralix.tan.enums.ClaimType;
import org.leralix.tan.enums.MapSettings;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class MapCommand
extends PlayerSubCommand {
    public String getName() {
        return "map";
    }

    public String getDescription() {
        return Lang.MAP_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan map";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return new ArrayList<String>();
    }

    public void perform(Player player, String[] args) {
        if (args.length == 1) {
            MapCommand.openMap(player, new MapSettings());
            return;
        }
        if (args.length == 3) {
            MapCommand.openMap(player, new MapSettings(args[1], args[2]));
            return;
        }
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        player.sendMessage(Lang.TOO_MANY_ARGS_ERROR.get(langType, new String[0]));
        player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
    }

    public static void openMap(Player player, MapSettings settings) {
        Chunk currentChunk = player.getLocation().getChunk();
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        int radius = 4;
        HashMap<Integer, TextComponent> text = new HashMap<Integer, TextComponent>();
        TextComponent claimType = new TextComponent(Lang.MAP_CLAIM_TYPE.get(langType, new String[0]));
        claimType.setHoverEvent(null);
        claimType.setClickEvent(null);
        claimType.setColor(ChatColor.GRAY);
        text.put(-4, claimType);
        TextComponent typeButton = settings.getMapTypeButton(langType);
        text.put(-3, typeButton);
        TextComponent actionButton = settings.getClaimTypeButton(langType);
        text.put(-2, actionButton);
        player.sendMessage("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u27e2\u27d0\u27e3\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u256e");
        for (int dz = -radius; dz <= radius; ++dz) {
            TextComponent newLine = new TextComponent();
            newLine.addExtra("   ");
            for (int dx = -radius; dx <= radius; ++dx) {
                int chunkX = currentChunk.getX();
                int chunkZ = currentChunk.getZ();
                ClaimedChunk2 claimedChunk = NewClaimedChunkStorage.getInstance().get(chunkX += dx, chunkZ += dz, player.getWorld().getUID().toString());
                TextComponent icon = claimedChunk.getMapIcon(langType);
                if (dx == 0 && dz == 0) {
                    TerritoryChunk territoryChunk;
                    if (claimedChunk instanceof TerritoryChunk && (territoryChunk = (TerritoryChunk)claimedChunk).isOccupied()) {
                        icon.setText("\ud83d\udfe0");
                    } else {
                        icon.setText("\ud83c\udf11");
                    }
                }
                ClaimAction claimAction = settings.getClaimActionType();
                ClaimType mapType = settings.getClaimType();
                icon.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tan " + claimAction.toString().toLowerCase() + " " + mapType.toString().toLowerCase() + " " + chunkX + " " + chunkZ));
                newLine.addExtra((BaseComponent)icon);
            }
            if (text.containsKey(dz)) {
                newLine.addExtra((BaseComponent)text.get(dz));
            }
            player.spigot().sendMessage((BaseComponent)newLine);
        }
        player.sendMessage("\u2570\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u27e2\u27d0\u27e3\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u256f");
    }
}

