/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class PayCommand
extends PlayerSubCommand {
    public String getName() {
        return "pay";
    }

    public String getDescription() {
        return Lang.PAY_COMMAND_DESC.getDefault();
    }

    public String getSyntax() {
        return "/tan pay <player> <amount>";
    }

    public int getArguments() {
        return 3;
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return PayCommand.payPlayerSuggestion((String[])args);
    }

    public void perform(Player player, String[] args) {
        int amount;
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        if (args.length < 3) {
            player.sendMessage(Lang.NOT_ENOUGH_ARGS_ERROR.get(langType, new String[0]));
            player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
            return;
        }
        if (args.length > 3) {
            player.sendMessage(Lang.TOO_MANY_ARGS_ERROR.get(langType, new String[0]));
            player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
            return;
        }
        Player receiver = Bukkit.getServer().getPlayer(args[1]);
        if (receiver == null) {
            player.sendMessage(Lang.PLAYER_NOT_FOUND.get(langType, new String[0]));
            return;
        }
        if (receiver.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(Lang.PAY_SELF_ERROR.get(langType, new String[0]));
            return;
        }
        Location senderLocation = player.getLocation();
        Location receiverLocation = receiver.getLocation();
        if (senderLocation.getWorld() != receiverLocation.getWorld()) {
            player.sendMessage(Lang.INTERACTION_TOO_FAR_ERROR.get(langType, new String[0]));
            return;
        }
        if (senderLocation.distance(receiverLocation) > (double)ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("maxPayDistance")) {
            player.sendMessage(Lang.INTERACTION_TOO_FAR_ERROR.get(langType, new String[0]));
            return;
        }
        try {
            amount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(Lang.SYNTAX_ERROR_AMOUNT.get(langType, new String[0]));
            return;
        }
        if (amount < 1) {
            player.sendMessage(Lang.PAY_MINIMUM_REQUIRED.get(langType, new String[0]));
            return;
        }
        if (EconomyUtil.getBalance(player) < (double)amount) {
            player.sendMessage(Lang.PLAYER_NOT_ENOUGH_MONEY_EXTENDED.get(langType, Double.toString((double)amount - EconomyUtil.getBalance(player))));
            return;
        }
        EconomyUtil.removeFromBalance(player, (double)amount);
        EconomyUtil.addFromBalance(receiver, (double)amount);
        player.sendMessage(Lang.PAY_CONFIRMED_SENDER.get(langType, Integer.toString(amount), receiver.getName()));
        receiver.sendMessage(Lang.PAY_CONFIRMED_RECEIVER.get(langType, Integer.toString(amount), player.getName()));
    }
}

