/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TownClaimedChunk;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;

public class SetTownSpawnCommand
extends PlayerSubCommand {
    public String getName() {
        return "setspawn";
    }

    public String getDescription() {
        return Lang.SET_SPAWN_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan setspawn";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(Player player, String[] args) {
        TownClaimedChunk townChunk;
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        if (args.length != 1) {
            player.sendMessage(Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
            return;
        }
        ITanPlayer playerStat = PlayerDataStorage.getInstance().get(player.getUniqueId().toString());
        if (!playerStat.hasTown()) {
            player.sendMessage(Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
            return;
        }
        TownData townData = TownDataStorage.getInstance().get(player);
        if (!townData.doesPlayerHavePermission(playerStat, RolePermission.TOWN_ADMINISTRATOR)) {
            player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(langType, new String[0]));
            return;
        }
        if (townData.isSpawnLocked()) {
            player.sendMessage(Lang.SPAWN_NOT_UNLOCKED.get(langType, new String[0]));
            return;
        }
        ClaimedChunk2 currentChunk = NewClaimedChunkStorage.getInstance().get(player.getLocation().getChunk());
        if (!(currentChunk instanceof TownClaimedChunk) || !(townChunk = (TownClaimedChunk)currentChunk).getTown().equals(townData)) {
            player.sendMessage(Lang.SPAWN_NEED_TO_BE_IN_CHUNK.get(langType, new String[0]));
            return;
        }
        townData.setSpawn(player.getLocation());
        player.sendMessage(Lang.SPAWN_SET_SUCCESS.get(langType, new String[0]));
    }
}

