/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.server;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.SubCommand;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;

public class ApplyTownServer
extends SubCommand {
    public String getName() {
        return "applytown";
    }

    public String getDescription() {
        return Lang.APPLY_TOWN_SERVER_DESC.getDefault();
    }

    public int getArguments() {
        return 3;
    }

    public String getSyntax() {
        return "/tanserver apply <town ID> <player username>";
    }

    public List<String> getTabCompleteSuggestions(CommandSender commandSender, String currentMessage, String[] args) {
        return Collections.emptyList();
    }

    public void perform(CommandSender commandSender, String[] args) {
        if (args.length < 3) {
            commandSender.sendMessage(Lang.INVALID_ARGUMENTS.getDefault());
            return;
        }
        String townID = args[1];
        String playerName = args[2];
        Player p = commandSender.getServer().getPlayer(playerName);
        if (p == null) {
            commandSender.sendMessage(Lang.PLAYER_NOT_FOUND.getDefault());
            return;
        }
        if (townID == null) {
            commandSender.sendMessage(Lang.TOWN_NOT_FOUND.getDefault());
            return;
        }
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(p.getUniqueId().toString());
        if (tanPlayer.hasTown()) {
            commandSender.sendMessage(Lang.PLAYER_ALREADY_HAVE_TOWN.getDefault());
            return;
        }
        TownData townData = (TownData)TownDataStorage.getInstance().get(townID);
        townData.addPlayerJoinRequest(p);
    }
}

