/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.server;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.leralix.lib.commands.SubCommand;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.LandmarkStorage;

public class LandmarkSetStoredLimitServer
extends SubCommand {
    public String getName() {
        return "landmarkSetStoredLimit";
    }

    public String getDescription() {
        return Lang.LANDMARK_UPDATE_SERVER_DESC.getDefault();
    }

    public int getArguments() {
        return 3;
    }

    public String getSyntax() {
        return "/tanserver landmarkSetStoredLimit <id> <value>";
    }

    public List<String> getTabCompleteSuggestions(CommandSender commandSender, String s, String[] args) {
        if (args.length == 2) {
            return LandmarkStorage.getInstance().getAll().values().stream().map(Landmark::getID).toList();
        }
        return Collections.emptyList();
    }

    public void perform(CommandSender commandSender, String[] args) {
        if (args.length < 3) {
            commandSender.sendMessage(Lang.INVALID_ARGUMENTS.getDefault());
        } else {
            Landmark landmark = (Landmark)LandmarkStorage.getInstance().get(args[1]);
            if (landmark == null) {
                commandSender.sendMessage(Lang.LANDMARK_NOT_FOUND.getDefault());
                return;
            }
            String value = args[2];
            if (value == null) {
                commandSender.sendMessage(Lang.INVALID_ARGUMENTS.getDefault());
                return;
            }
            landmark.setStoredLimit(Integer.parseInt(value));
            commandSender.sendMessage(Lang.LANDMARK_STORED_UPDATED.get(Lang.getServerLang(), landmark.getName(), landmark.getID(), value));
        }
    }
}

