/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.server;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.leralix.lib.commands.SubCommand;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.LandmarkStorage;

public class LandmarkUpdateServer
extends SubCommand {
    public String getName() {
        return "landmarkUpdate";
    }

    public String getDescription() {
        return Lang.LANDMARK_UPDATE_SERVER_DESC.getDefault();
    }

    public int getArguments() {
        return 2;
    }

    public String getSyntax() {
        return "/tanserver landmarkUpdate <id?>";
    }

    public List<String> getTabCompleteSuggestions(CommandSender commandSender, String s, String[] args) {
        if (args.length == 2) {
            return LandmarkStorage.getInstance().getAll().values().stream().map(Landmark::getID).toList();
        }
        return Collections.emptyList();
    }

    public void perform(CommandSender commandSender, String[] args) {
        LandmarkStorage instance = LandmarkStorage.getInstance();
        if (args.length < 2) {
            instance.generateAllResources();
            commandSender.sendMessage(Lang.ALL_LANDMARK_UPDATED.getDefault());
        } else {
            Landmark landmark = (Landmark)instance.get(args[1]);
            landmark.generateResources();
            commandSender.sendMessage(Lang.LANDMARK_UPDATED.get(Lang.getServerLang(), landmark.getName(), landmark.getID()));
        }
    }
}

