/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.server;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.SubCommand;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;

class QuitTownServer
extends SubCommand {
    QuitTownServer() {
    }

    public String getName() {
        return "quittown";
    }

    public String getDescription() {
        return Lang.QUIT_TOWN_SERVER_DESC.getDefault();
    }

    public int getArguments() {
        return 2;
    }

    public String getSyntax() {
        return "/tanserver quittown <player_username>";
    }

    public List<String> getTabCompleteSuggestions(CommandSender commandSender, String currentMessage, String[] args) {
        return Collections.emptyList();
    }

    public void perform(CommandSender commandSender, String[] args) {
        if (args.length < 2) {
            commandSender.sendMessage(Lang.INVALID_ARGUMENTS.getDefault());
            return;
        }
        Player p = commandSender.getServer().getPlayer(args[1]);
        if (p == null) {
            commandSender.sendMessage(Lang.PLAYER_NOT_FOUND.getDefault());
            return;
        }
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(p);
        TownData townData = tanPlayer.getTown();
        if (townData == null) {
            commandSender.sendMessage(Lang.PLAYER_NO_TOWN.get(tanPlayer));
            return;
        }
        if (townData.isLeader(tanPlayer)) {
            commandSender.sendMessage(Lang.LEADER_CANNOT_QUIT_TOWN.get(tanPlayer));
            return;
        }
        townData.removePlayer(tanPlayer);
    }
}

