/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.WildernessChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.LandmarkClaimedInternalEvent;
import org.leralix.tan.events.events.LandmarkUnclaimedInternalEvent;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.gameplay.TANCustomNBT;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public class Landmark {
    private final String ID;
    private String name;
    private final Vector3D position;
    private String materialName;
    private int amount;
    private String ownerID;
    private int storedDays;
    private int storedLimit;

    public Landmark(String id, Vector3D position) {
        this.ID = id;
        this.name = Lang.SPECIFIC_LANDMARK_ICON_DEFAULT_NAME.get(Lang.getServerLang(), this.getID());
        this.position = position;
        this.materialName = "DIAMOND";
        this.amount = 2;
        this.storedDays = 0;
        this.storedLimit = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("storedLimit", 7);
        this.spawnChest();
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setOwner(TownData newOwner) {
        EventManager.getInstance().callEvent(new LandmarkClaimedInternalEvent(this, newOwner));
        this.ownerID = newOwner.getID();
    }

    public void removeOwnership() {
        EventManager.getInstance().callEvent(new LandmarkUnclaimedInternalEvent(this, this.getOwner()));
        this.ownerID = null;
    }

    public String getOwnerID() {
        return this.ownerID;
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public void spawnChest() {
        Block newBlock = this.position.getWorld().getBlockAt(this.position.getLocation());
        newBlock.setType(Material.CHEST);
        TANCustomNBT.setBockMetaData(newBlock, "LandmarkChest", this.getID());
    }

    public void dispawnChest() {
        Block newBlock = this.position.getWorld().getBlockAt(this.position.getLocation());
        TANCustomNBT.removeBockMetaData(newBlock, "LandmarkChest");
        newBlock.setType(Material.AIR);
    }

    public Optional<Block> getChest() {
        World world = this.position.getWorld();
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(this.position.getWorld().getBlockAt(this.position.getLocation()));
    }

    public Material getRessourceMaterial() {
        return Material.valueOf((String)this.materialName);
    }

    public ItemStack getResources() {
        ItemStack ressourcesItemStack = new ItemStack(this.getRessourceMaterial());
        ressourcesItemStack.setAmount(this.amount);
        return ressourcesItemStack;
    }

    public void generateResources() {
        if (!this.isOwned()) {
            return;
        }
        if (this.storedDays >= this.storedLimit) {
            return;
        }
        ++this.storedDays;
    }

    public void setStoredLimit(int limit) {
        this.storedLimit = limit;
    }

    public boolean isOwned() {
        if (this.ownerID == null) {
            return false;
        }
        if (TerritoryUtil.getTerritory(this.ownerID) == null) {
            this.removeOwnership();
            return false;
        }
        return true;
    }

    private TownData getOwner() {
        return (TownData)TownDataStorage.getInstance().get(this.ownerID);
    }

    public ItemStack getIcon(LangType langType) {
        Material rewardMaterial = Material.valueOf((String)this.materialName);
        ItemStack icon = new ItemStack(rewardMaterial, this.amount);
        ItemMeta meta = icon.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.getName());
            List<String> description = this.getBaseDescription(langType);
            if (this.isOwned()) {
                description.add(Lang.SPECIFIC_LANDMARK_ICON_DESC2_OWNER.get(langType, this.getOwner().getName()));
            } else {
                description.add(Lang.SPECIFIC_LANDMARK_ICON_DESC2_NO_OWNER.get(langType, new String[0]));
            }
            meta.setLore(description);
        }
        icon.setItemMeta(meta);
        return icon;
    }

    public List<String> getBaseDescription(LangType langType) {
        ArrayList<String> description = new ArrayList<String>();
        description.add(Lang.DISPLAY_COORDINATES.get(langType, Integer.toString(this.position.getX()), Integer.toString(this.position.getY()), Integer.toString(this.position.getZ())));
        description.add(Lang.SPECIFIC_LANDMARK_ICON_DESC1.get(langType, Integer.toString(this.amount), this.materialName.toLowerCase()));
        return description;
    }

    public void deleteLandmark() {
        this.dispawnChest();
        NewClaimedChunkStorage.getInstance().unclaimChunk(this.position.getLocation().getChunk());
        LandmarkStorage.getInstance().delete(this.getID());
    }

    public int computeStoredReward(TownData townData) {
        long bonus = (townData.getLevel().getTotalBenefits().get("LANDMARK_BONUS") + 100) / 100;
        return (int)((long)(this.amount * this.storedDays) * bonus);
    }

    public void giveToPlayer(Player player, int number) {
        if (this.storedDays == 0) {
            return;
        }
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.valueOf((String)this.materialName), number)});
        this.storedDays = 0;
    }

    public void setReward(ItemStack itemOnCursor) {
        this.amount = itemOnCursor.getAmount();
        this.materialName = itemOnCursor.getType().name();
        LandmarkStorage.getInstance().save();
    }

    public Location getLocation() {
        return new Location(this.position.getWorld(), (double)this.position.getX(), (double)this.position.getY(), (double)this.position.getZ());
    }

    public boolean isEncircledBy(TownData playerTown) {
        Chunk chunk = this.position.getLocation().getChunk();
        boolean isEncircled = true;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                Chunk neighborChunk = chunk.getWorld().getChunkAt(chunk.getX() + x, chunk.getZ() + z);
                ClaimedChunk2 neighborClaimedChunk = NewClaimedChunkStorage.getInstance().get(neighborChunk);
                if (!(neighborClaimedChunk instanceof WildernessChunk) && neighborClaimedChunk.getOwner().equals(playerTown)) continue;
                isEncircled = false;
                break;
            }
            if (!isEncircled) break;
        }
        return isEncircled;
    }

    public void setProtectedBlockData() {
        if (this.getChest().isEmpty()) {
            return;
        }
        TANCustomNBT.setBockMetaData(this.getChest().get(), "LandmarkChest", this.getID());
    }

    public boolean isOwnedBy(TerritoryData territoryData) {
        if (territoryData == null) {
            return false;
        }
        if (this.ownerID == null) {
            return false;
        }
        return this.ownerID.equals(territoryData.getID());
    }
}

