/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.ParticleUtils;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.newhistory.PropertyBuyTaxTransaction;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.dataclass.territory.cosmetic.CustomIcon;
import org.leralix.tan.dataclass.territory.cosmetic.ICustomIcon;
import org.leralix.tan.dataclass.territory.permission.RelationPermission;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.listeners.interact.events.CreatePropertyEvent;
import org.leralix.tan.storage.PermissionManager;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.gameplay.TANCustomNBT;
import org.leralix.tan.utils.text.NumberUtil;

public class PropertyData {
    private final String ID;
    private String owningPlayerID;
    private String rentingPlayerID;
    private PermissionManager permissionManager;
    private ICustomIcon icon;
    private String name;
    private String description;
    private boolean isForSale;
    private double salePrice;
    private boolean isForRent;
    private double rentPrice;
    private final Vector3D p1;
    private final Vector3D p2;
    private Vector3D signLocation;
    private Vector3D supportLocation;

    public PropertyData(String id, Vector3D p1, Vector3D p2, ITanPlayer player) {
        this.ID = id;
        this.owningPlayerID = player.getID();
        this.p1 = p1;
        this.p2 = p2;
        ItemStack itemStack = new ItemStack(Material.OAK_SIGN);
        this.icon = new CustomIcon(itemStack);
        this.name = "Unnamed Zone";
        this.description = "No description";
        this.isForSale = false;
        this.salePrice = 0.0;
        this.isForRent = false;
        this.rentingPlayerID = null;
        this.rentPrice = 0.0;
        this.permissionManager = new PermissionManager(RelationPermission.SELECTED_ONLY);
    }

    public Vector3D getFirstCorner() {
        return this.p1;
    }

    public Vector3D getSecondCorner() {
        return this.p2;
    }

    public String getTotalID() {
        return this.ID;
    }

    public void setIcon(CustomIcon icon) {
        this.icon = icon;
    }

    public ItemStack getIcon() {
        if (this.icon == null) {
            this.icon = new CustomIcon(new ItemStack(Material.OAK_SIGN));
        }
        return this.icon.getIcon();
    }

    private String getOwningStructureID() {
        String[] parts = this.ID.split("_");
        return parts[0];
    }

    public TownData getTown() {
        return (TownData)TownDataStorage.getInstance().get(this.getOwningStructureID());
    }

    public String getPropertyID() {
        String[] parts = this.ID.split("_");
        return parts[1];
    }

    public void setName(String name) {
        this.name = name;
        Bukkit.getScheduler().runTask((Plugin)TownsAndNations.getPlugin(), this::updateSign);
    }

    public void setDescription(String description) {
        this.description = description;
        Bukkit.getScheduler().runTask((Plugin)TownsAndNations.getPlugin(), this::updateSign);
    }

    public String getOwnerID() {
        return this.owningPlayerID;
    }

    public ITanPlayer getOwner() {
        return PlayerDataStorage.getInstance().get(this.owningPlayerID);
    }

    public void allocateRenter(Player renter) {
        this.rentingPlayerID = renter.getUniqueId().toString();
        this.isForRent = false;
        if (ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("payRentAtStart", false)) {
            this.payRent();
        }
        this.updateSign();
        this.getPermissionManager().setAll(RelationPermission.SELECTED_ONLY);
    }

    public boolean isRented() {
        return this.rentingPlayerID != null;
    }

    public boolean isForRent() {
        return this.isForRent;
    }

    public ITanPlayer getRenter() {
        return PlayerDataStorage.getInstance().get(this.rentingPlayerID);
    }

    public String getRenterID() {
        return this.rentingPlayerID;
    }

    public Player getRenterPlayer() {
        return Bukkit.getPlayer((UUID)UUID.fromString(this.rentingPlayerID));
    }

    public OfflinePlayer getOfflineRenter() {
        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.rentingPlayerID));
    }

    public Player getOwnerPlayer() {
        return Bukkit.getPlayer((UUID)UUID.fromString(this.owningPlayerID));
    }

    public String getDescription() {
        return this.description;
    }

    public void payRent() {
        OfflinePlayer renter = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.rentingPlayerID));
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.owningPlayerID));
        TownData town = this.getTown();
        double baseRent = this.getBaseRentPrice();
        double rent = this.getRentPrice();
        double taxRent = rent - baseRent;
        if (EconomyUtil.getBalance(renter) < rent) {
            this.expelRenter(true);
            return;
        }
        EconomyUtil.removeFromBalance(renter, rent);
        EconomyUtil.addFromBalance(owner, baseRent);
        town.addToBalance(taxRent);
    }

    public boolean isOwner(String playerID) {
        return playerID.equals(this.owningPlayerID);
    }

    public String getName() {
        return this.name;
    }

    public boolean isForSale() {
        return this.isForSale;
    }

    public double getBaseRentPrice() {
        return this.rentPrice;
    }

    public double getRentPrice() {
        return NumberUtil.roundWithDigits(this.getBaseRentPrice() * (1.0 + this.getTown().getTaxOnRentingProperty()));
    }

    public double getBaseSalePrice() {
        return this.salePrice;
    }

    public double getSalePrice() {
        return NumberUtil.roundWithDigits(this.getBaseSalePrice() * (1.0 + this.getTown().getTaxOnBuyingProperty()));
    }

    public boolean containsLocation(Location location) {
        return (double)Math.max(this.p1.getX(), this.p2.getX()) >= location.getX() && (double)Math.min(this.p1.getX(), this.p2.getX()) <= location.getX() && (double)Math.max(this.p1.getY(), this.p2.getY()) >= location.getY() && (double)Math.min(this.p1.getY(), this.p2.getY()) <= location.getY() && (double)Math.max(this.p1.getZ(), this.p2.getZ()) >= location.getZ() && (double)Math.min(this.p1.getZ(), this.p2.getZ()) <= location.getZ();
    }

    public List<String> getBasicDescription(LangType langType) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(Lang.GUI_PROPERTY_DESCRIPTION.get(langType, this.getDescription()));
        lore.add(Lang.GUI_PROPERTY_STRUCTURE_OWNER.get(langType, this.getTown().getName()));
        lore.add(Lang.GUI_PROPERTY_OWNER.get(langType, this.getOwner().getNameStored()));
        if (this.isForSale()) {
            lore.add(Lang.GUI_PROPERTY_FOR_SALE.get(langType, String.valueOf(this.salePrice)));
        } else if (this.isRented()) {
            lore.add(Lang.GUI_PROPERTY_RENTED_BY.get(langType, this.getRenter().getNameStored(), String.valueOf(this.rentPrice)));
        } else if (this.isForRent()) {
            lore.add(Lang.GUI_PROPERTY_FOR_RENT.get(langType, String.valueOf(this.rentPrice)));
        } else {
            lore.add(Lang.GUI_PROPERTY_NOT_FOR_SALE.get(langType, new String[0]));
        }
        return lore;
    }

    public void swapIsForSale() {
        boolean bl = this.isForSale = !this.isForSale;
        if (this.isForSale) {
            this.isForRent = false;
        }
        this.updateSign();
    }

    public void swapIsRent() {
        boolean bl = this.isForRent = !this.isForRent;
        if (this.isForRent) {
            this.isForSale = false;
        }
        this.updateSign();
    }

    public void showBox(Player player) {
        ParticleUtils.showBox((Plugin)TownsAndNations.getPlugin(), (Player)player, (Vector3D)this.getFirstCorner(), (Vector3D)this.getSecondCorner(), (int)10);
    }

    public void updateSign() {
        World world = Bukkit.getWorld((UUID)this.signLocation.getWorldID());
        if (world == null) {
            return;
        }
        Block signBlock = world.getBlockAt(this.signLocation.getX(), this.signLocation.getY(), this.signLocation.getZ());
        Sign sign = (Sign)signBlock.getState();
        String[] lines = this.updateLines();
        SignSide signSide = sign.getSide(Side.FRONT);
        signSide.setLine(0, lines[0]);
        signSide.setLine(1, lines[1]);
        signSide.setLine(2, lines[2]);
        signSide.setLine(3, lines[3]);
        sign.update();
    }

    private String[] updateLines() {
        String[] lines = new String[4];
        LangType langType = Lang.getServerLang();
        lines[0] = Lang.SIGN_NAME.get(langType, this.getName());
        lines[1] = Lang.SIGN_PLAYER.get(langType, PlayerDataStorage.getInstance().get(this.getOwnerID()).getNameStored());
        if (this.isForSale) {
            lines[2] = Lang.SIGN_FOR_SALE.get(langType, new String[0]);
            lines[3] = Lang.SIGN_SALE_PRICE.get(langType, Double.toString(this.getSalePrice()));
        } else if (this.isForRent) {
            lines[2] = Lang.SIGN_RENT.get(langType, new String[0]);
            lines[3] = Lang.SIGN_RENT_PRICE.get(langType, Double.toString(this.getRentPrice()));
        } else if (this.isRented()) {
            lines[2] = Lang.SIGN_RENTED_BY.get(langType, new String[0]);
            lines[3] = this.getRenter().getNameStored();
        } else {
            lines[2] = Lang.SIGN_NOT_FOR_SALE.get(langType, new String[0]);
            lines[3] = "";
        }
        return lines;
    }

    public void setRentPrice(double i) {
        this.rentPrice = i;
        Bukkit.getScheduler().runTask((Plugin)TownsAndNations.getPlugin(), this::updateSign);
    }

    public void setSalePrice(double i) {
        this.salePrice = i;
        Bukkit.getScheduler().runTask((Plugin)TownsAndNations.getPlugin(), this::updateSign);
    }

    public Optional<Block> getSign() {
        World world = Bukkit.getWorld((UUID)this.signLocation.getWorldID());
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(world.getBlockAt(this.signLocation.getX(), this.signLocation.getY(), this.signLocation.getZ()));
    }

    public void delete() {
        ITanPlayer owner = PlayerDataStorage.getInstance().get(this.owningPlayerID);
        TownData town = this.getTown();
        this.expelRenter(false);
        this.removeSign();
        owner.removeProperty(this);
        town.removeProperty(this);
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.owningPlayerID));
        if (player != null) {
            player.sendMessage(Lang.PROPERTY_DELETED.get(owner.getLang(), new String[0]));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
        }
    }

    private void removeSign() {
        World world = Bukkit.getWorld((UUID)this.signLocation.getWorldID());
        if (world == null) {
            return;
        }
        Block signBlock = this.signLocation.getLocation().getBlock();
        signBlock.setType(Material.AIR);
        TANCustomNBT.removeBockMetaData(signBlock, "propertySign");
        TANCustomNBT.removeBockMetaData(this.supportLocation.getLocation().getBlock(), "propertySign");
        world.spawnParticle(Particle.BUBBLE_POP, signBlock.getLocation(), 5);
    }

    public void buyProperty(Player player) {
        double cost;
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        double playerBalance = EconomyUtil.getBalance(player);
        if (playerBalance < (cost = this.getSalePrice())) {
            player.sendMessage(Lang.PLAYER_NOT_ENOUGH_MONEY_EXTENDED.get(player, Double.toString(cost - playerBalance)));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_BAD);
            return;
        }
        Player exOwner = Bukkit.getPlayer((UUID)UUID.fromString(this.owningPlayerID));
        OfflinePlayer exOwnerOffline = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.owningPlayerID));
        if (exOwner != null) {
            exOwner.sendMessage(Lang.PROPERTY_SOLD_EX_OWNER.get(player, this.getName(), player.getName(), Double.toString(this.getSalePrice())));
            SoundUtil.playSound((Player)exOwner, (SoundEnum)SoundEnum.GOOD);
        }
        player.sendMessage(Lang.PROPERTY_SOLD_NEW_OWNER.get(player, this.getName(), Double.toString(this.getSalePrice())));
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.GOOD);
        TownData town = this.getTown();
        double townCut = this.getSalePrice() - this.getBaseSalePrice();
        TownsAndNations.getPlugin().getDatabaseHandler().addTransactionHistory(new PropertyBuyTaxTransaction(town, this, townCut));
        EconomyUtil.removeFromBalance(player, this.getSalePrice());
        EconomyUtil.addFromBalance(exOwnerOffline, this.getBaseSalePrice());
        town.addToBalance(townCut);
        ITanPlayer exOwnerData = PlayerDataStorage.getInstance().get(this.owningPlayerID);
        ITanPlayer newOwnerData = PlayerDataStorage.getInstance().get(player.getUniqueId().toString());
        exOwnerData.removeProperty(this);
        newOwnerData.addProperty(this);
        this.owningPlayerID = player.getUniqueId().toString();
        this.isForSale = false;
        this.updateSign();
        this.getPermissionManager().setAll(RelationPermission.SELECTED_ONLY);
    }

    public boolean isPlayerAllowed(ChunkPermissionType action, ITanPlayer tanPlayer) {
        if (this.getPermissionManager().canPlayerDo(this.getTown(), action, tanPlayer)) {
            return true;
        }
        if (this.isRented()) {
            return tanPlayer.getID().equals(this.rentingPlayerID);
        }
        return this.isOwner(tanPlayer.getID());
    }

    public String getDenyMessage(LangType langType) {
        if (this.isRented()) {
            return Lang.PROPERTY_RENTED_BY.get(langType, this.getRenter().getNameStored());
        }
        return Lang.PROPERTY_BELONGS_TO.get(langType, this.getOwner().getNameStored());
    }

    public void expelRenter(boolean rentBack) {
        if (!this.isRented()) {
            return;
        }
        ITanPlayer renter = PlayerDataStorage.getInstance().get(this.rentingPlayerID);
        renter.removeProperty(this);
        this.rentingPlayerID = null;
        if (rentBack) {
            this.isForRent = true;
        }
        this.updateSign();
        this.getPermissionManager().setAll(RelationPermission.SELECTED_ONLY);
    }

    public boolean canPlayerManageInvites(String id) {
        if (!this.isRented() && this.isOwner(id)) {
            return true;
        }
        return this.isRented() && Objects.equals(this.getRenterID(), id);
    }

    public boolean isInChunk(ClaimedChunk2 chunk) {
        int minX = Math.min(this.p1.getX() >> 4, this.p2.getX() >> 4);
        int maxX = Math.max(this.p1.getX() >> 4, this.p2.getX() >> 4);
        int minZ = Math.min(this.p1.getZ() >> 4, this.p2.getZ() >> 4);
        int maxZ = Math.max(this.p1.getZ() >> 4, this.p2.getZ() >> 4);
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        return chunkX >= minX && chunkX <= maxX && chunkZ >= minZ && chunkZ <= maxZ;
    }

    public PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = new PermissionManager(RelationPermission.SELECTED_ONLY);
        }
        return this.permissionManager;
    }

    public void setSignData() {
        TANCustomNBT.setBockMetaData(this.signLocation.getLocation().getBlock(), "propertySign", this.getTotalID());
        TANCustomNBT.setBockMetaData(this.supportLocation.getLocation().getBlock(), "propertySign", this.getTotalID());
    }

    public void createPropertySign(Player player, Block block, BlockFace blockFace) {
        Location selectedSignLocation = block.getRelative(blockFace).getLocation();
        selectedSignLocation.getBlock().setType(blockFace == BlockFace.UP ? Material.OAK_SIGN : Material.OAK_WALL_SIGN);
        BlockState blockState = selectedSignLocation.getBlock().getState();
        Sign sign = (Sign)blockState;
        if (blockFace != BlockFace.UP) {
            BlockFace direction = CreatePropertyEvent.getTopDirection(block.getLocation(), player.getLocation());
            Directional directional = (Directional)sign.getBlockData();
            directional.setFacing(direction);
            sign.setBlockData((BlockData)directional);
        } else {
            org.bukkit.block.data.type.Sign signData = (org.bukkit.block.data.type.Sign)sign.getBlockData();
            BlockFace direction = CreatePropertyEvent.getTopDirection(block.getLocation(), player.getLocation());
            signData.setRotation(direction);
            sign.setBlockData((BlockData)signData);
        }
        sign.update();
        block.setMetadata("propertySign", (MetadataValue)new FixedMetadataValue((Plugin)TownsAndNations.getPlugin(), (Object)this.getTotalID()));
        sign.getBlock().setMetadata("propertySign", (MetadataValue)new FixedMetadataValue((Plugin)TownsAndNations.getPlugin(), (Object)this.getTotalID()));
        this.signLocation = new Vector3D(selectedSignLocation);
        this.supportLocation = new Vector3D(block.getLocation());
        this.setSignData();
        this.updateSign();
    }
}

