/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public class RelationData {
    private final Map<TownRelation, List<String>> townRelations = new LinkedHashMap<TownRelation, List<String>>();

    public RelationData() {
        this.townRelations.put(TownRelation.WAR, new ArrayList());
        this.townRelations.put(TownRelation.EMBARGO, new ArrayList());
        this.townRelations.put(TownRelation.NON_AGGRESSION, new ArrayList());
        this.townRelations.put(TownRelation.ALLIANCE, new ArrayList());
    }

    public void setRelation(TownRelation relation, TerritoryData territoryID) {
        this.setRelation(relation, territoryID.getID());
    }

    public void setRelation(TownRelation relation, String territoryID) {
        this.removeAllRelationWith(territoryID);
        if (!this.townRelations.containsKey((Object)relation)) {
            return;
        }
        this.addRelation(relation, territoryID);
    }

    public void addRelation(TownRelation relation, String townID) {
        this.townRelations.get((Object)relation).add(townID);
    }

    public void removeRelation(TownRelation relation, String townID) {
        if (!this.townRelations.containsKey((Object)relation)) {
            return;
        }
        this.townRelations.get((Object)relation).remove(townID);
    }

    public List<String> getTerritoriesIDWithRelation(TownRelation relation) {
        return this.townRelations.get((Object)relation);
    }

    public Map<TownRelation, List<String>> getAll() {
        return this.townRelations;
    }

    public TownRelation getRelationWith(String territoryID) {
        for (Map.Entry<TownRelation, List<String>> entry : this.townRelations.entrySet()) {
            TownRelation relation = entry.getKey();
            List<String> list = entry.getValue();
            for (String townUUID : list) {
                if (!territoryID.equals(townUUID)) continue;
                return relation;
            }
        }
        return TownRelation.NEUTRAL;
    }

    public TownRelation getRelationWith(TerritoryData territory) {
        return this.getRelationWith(territory.getID());
    }

    public void cleanAll(TerritoryData territoryData) {
        for (TownRelation relation : TownRelation.values()) {
            Collection territories = this.townRelations.get((Object)relation);
            if (territories == null) continue;
            for (String otherTerritory : territories) {
                TerritoryData otherTerritoryData = TerritoryUtil.getTerritory(otherTerritory);
                if (otherTerritoryData == null) continue;
                otherTerritoryData.getRelations().removeAllRelationWith(territoryData.getID());
                otherTerritoryData.broadcastMessageWithSound(Lang.WARNING_OTHER_TOWN_HAS_BEEN_DELETED.get(territoryData.getBaseColoredName(), relation.getColoredName(Lang.getServerLang())), SoundEnum.MINOR_BAD);
            }
        }
    }

    public void removeAllRelationWith(String townID) {
        for (List<String> territories : this.townRelations.values()) {
            territories.remove(townID);
        }
    }
}

