/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.chunk;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.chunk.ChunkType;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.territory.ChunkUtil;

public class LandmarkClaimedChunk
extends ClaimedChunk2 {
    public LandmarkClaimedChunk(Chunk chunk, String owner) {
        super(chunk, owner);
    }

    public LandmarkClaimedChunk(int x, int z, String worldUUID, String ownerID) {
        super(x, z, worldUUID, ownerID);
    }

    @Override
    public String getName() {
        return ((TownData)TownDataStorage.getInstance().get(this.getOwnerID())).getName();
    }

    @Override
    protected boolean canPlayerDoInternal(Player player, ChunkPermissionType permissionType, Location location) {
        if (permissionType == ChunkPermissionType.INTERACT_CHEST || permissionType == ChunkPermissionType.INTERACT_DOOR || permissionType == ChunkPermissionType.ATTACK_PASSIVE_MOB || permissionType == ChunkPermissionType.INTERACT_BUTTON || permissionType == ChunkPermissionType.INTERACT_REDSTONE || permissionType == ChunkPermissionType.INTERACT_FURNACE || permissionType == ChunkPermissionType.INTERACT_ITEM_FRAME || permissionType == ChunkPermissionType.INTERACT_ARMOR_STAND || permissionType == ChunkPermissionType.INTERACT_DECORATIVE_BLOCK || permissionType == ChunkPermissionType.INTERACT_MUSIC_BLOCK || permissionType == ChunkPermissionType.USE_LEAD || permissionType == ChunkPermissionType.USE_SHEARS) {
            return true;
        }
        player.sendMessage(Lang.CANNOT_DO_IN_LANDMARK.get(player));
        return false;
    }

    public Landmark getLandMark() {
        return (Landmark)LandmarkStorage.getInstance().get(this.ownerID);
    }

    @Override
    public void unclaimChunk(Player player) {
        player.sendMessage(Lang.CANNOT_UNCLAIM_LANDMARK_CHUNK.get(player));
    }

    @Override
    public void playerEnterClaimedArea(Player player, boolean displayTerritoryColor) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Lang.PLAYER_ENTER_LANDMARK_CHUNK.getDefault()));
    }

    @Override
    public boolean canEntitySpawn(EntityType entityType) {
        return true;
    }

    @Override
    public TextComponent getMapIcon(LangType langType) {
        TextComponent textComponent = new TextComponent("\u2b1b");
        textComponent.setColor(ChatColor.GOLD);
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("x : " + super.getMiddleX() + " z : " + super.getMiddleZ() + "\n" + String.valueOf(ChatColor.GOLD) + this.getLandMark().getName() + "\n" + Lang.LEFT_CLICK_TO_CLAIM.get(langType, new String[0]))}));
        return textComponent;
    }

    @Override
    public boolean canTerritoryClaim(TerritoryData territoryData) {
        return false;
    }

    @Override
    public boolean canTerritoryClaim(Player player, TerritoryData territoryData) {
        player.sendMessage(Lang.CANNOT_CLAIM_LANDMARK.get(player));
        return false;
    }

    @Override
    public boolean isClaimed() {
        return true;
    }

    @Override
    public boolean canExplosionGrief() {
        return false;
    }

    @Override
    public boolean canFireGrief() {
        return false;
    }

    @Override
    public boolean canPVPHappen() {
        return true;
    }

    @Override
    public boolean canMobGrief() {
        return false;
    }

    @Override
    public ChunkType getType() {
        return ChunkType.LANDMARK;
    }

    @Override
    public void notifyUpdate() {
        if (Constants.isLandmarkClaimRequiresEncirclement() || !this.isClaimed()) {
            this.removeIfNotEncircled();
        }
    }

    private void removeIfNotEncircled() {
        Landmark landmark = this.getLandMark();
        if (ChunkUtil.isChunkEncirecledBy(this, chunk -> chunk.getOwnerID().equals(landmark.getOwnerID()))) {
            return;
        }
        this.getLandMark().removeOwnership();
    }
}

