/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.chunk;

import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Chunk;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.permissions.GeneralChunkSetting;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public abstract class TerritoryChunk
extends ClaimedChunk2 {
    private String occupierID;

    protected TerritoryChunk(Chunk chunk, String owner) {
        super(chunk, owner);
        this.occupierID = owner;
    }

    protected TerritoryChunk(int x, int z, String worldUUID, String owner) {
        super(x, z, worldUUID, owner);
        this.occupierID = owner;
    }

    @Override
    public TextComponent getMapIcon(LangType langType) {
        String text;
        TextComponent textComponent;
        if (this.isOccupied()) {
            textComponent = new TextComponent("\ud83d\udfe7");
            textComponent.setColor(this.getOccupier().getChunkColor());
            text = "x : " + super.getMiddleX() + " z : " + super.getMiddleZ() + "\n" + this.getOwner().getBaseColoredName() + "\n" + this.getOccupier().getBaseColoredName() + "\n" + Lang.LEFT_CLICK_TO_CLAIM.get(langType, new String[0]);
        } else {
            textComponent = new TextComponent("\u2b1b");
            textComponent.setColor(this.getOwner().getChunkColor());
            text = "x : " + super.getMiddleX() + " z : " + super.getMiddleZ() + "\n" + this.getOwner().getBaseColoredName() + "\n" + Lang.LEFT_CLICK_TO_CLAIM.get(langType, new String[0]);
        }
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(text)}));
        return textComponent;
    }

    public String getOccupierID() {
        if (this.occupierID == null) {
            this.occupierID = this.ownerID;
        }
        return this.occupierID;
    }

    @Override
    public boolean canExplosionGrief() {
        return Constants.getExplosionGriefStatus().canGrief(this.getOwner(), GeneralChunkSetting.TNT_GRIEF);
    }

    @Override
    public boolean canFireGrief() {
        return Constants.getFireGriefStatus().canGrief(this.getOwner(), GeneralChunkSetting.FIRE_GRIEF);
    }

    @Override
    public boolean canPVPHappen() {
        return Constants.getPvpStatus().canGrief(this.getOwner(), GeneralChunkSetting.ENABLE_PVP);
    }

    @Override
    public boolean canMobGrief() {
        return Constants.getMobGriefStatus().canGrief(this.getOwner(), GeneralChunkSetting.MOB_GRIEF);
    }

    public TerritoryData getOccupier() {
        return TerritoryUtil.getTerritory(this.getOccupierID());
    }

    public void setOccupier(TerritoryData occupier) {
        this.setOccupierID(occupier.getID());
    }

    public void setOccupierID(String occupierID) {
        this.occupierID = occupierID;
    }

    public void liberate() {
        this.occupierID = this.getOwnerID();
    }

    public boolean isOccupied() {
        return !this.ownerID.equals(this.occupierID);
    }
}

