/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.chunk;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.chunk.ChunkType;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.dataclass.territory.permission.ChunkPermission;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.territory.ChunkUtil;
import org.leralix.tan.war.legacy.CurrentAttack;

public class TownClaimedChunk
extends TerritoryChunk {
    public TownClaimedChunk(Chunk chunk, String owner) {
        super(chunk, owner);
    }

    public TownClaimedChunk(int x, int z, String worldUUID, String ownerID) {
        super(x, z, worldUUID, ownerID);
    }

    @Override
    public String getName() {
        return this.getTown().getName();
    }

    public TownData getTown() {
        return (TownData)TownDataStorage.getInstance().get(this.ownerID);
    }

    @Override
    protected boolean canPlayerDoInternal(Player player, ChunkPermissionType permissionType, Location location) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        TownData ownerTown = this.getTown();
        PropertyData property = ownerTown.getProperty(location);
        if (property != null) {
            if (property.isPlayerAllowed(permissionType, tanPlayer)) {
                return true;
            }
            player.sendMessage(property.getDenyMessage(tanPlayer.getLang()));
            return false;
        }
        if (!tanPlayer.hasTown()) {
            this.playerCantPerformAction(player);
            return false;
        }
        for (CurrentAttack currentAttacks : ownerTown.getCurrentAttacks()) {
            if (!currentAttacks.containsPlayer(tanPlayer)) continue;
            return true;
        }
        ChunkPermission chunkPermission = ownerTown.getPermission(permissionType);
        if (chunkPermission.isAllowed(ownerTown, tanPlayer)) {
            return true;
        }
        this.playerCantPerformAction(player);
        return false;
    }

    @Override
    public void unclaimChunk(Player player) {
        ITanPlayer playerStat = PlayerDataStorage.getInstance().get(player);
        LangType langType = playerStat.getLang();
        TownData playerTown = playerStat.getTown();
        if (playerTown == null) {
            player.sendMessage(Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
            return;
        }
        if (!playerTown.doesPlayerHavePermission(playerStat, RolePermission.UNCLAIM_CHUNK)) {
            player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(langType, new String[0]));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.NOT_ALLOWED);
            return;
        }
        if (!this.getOwner().equals(playerTown)) {
            player.sendMessage(Lang.UNCLAIMED_CHUNK_NOT_RIGHT_TOWN.get(langType, this.getOwner().getName()));
            return;
        }
        for (PropertyData propertyData : this.getTown().getProperties()) {
            if (!propertyData.isInChunk(this)) continue;
            player.sendMessage(Lang.PROPERTY_IN_CHUNK.get(langType, propertyData.getName()));
            return;
        }
        if (ChunkUtil.chunkContainsBuildings(this, playerTown)) {
            player.sendMessage(Lang.BUILDINGS_OR_CAPITAL_IN_CHUNK.get(langType, new String[0]));
            return;
        }
        NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(this);
        player.sendMessage(Lang.UNCLAIMED_CHUNK_SUCCESS_TOWN.get(langType, Integer.toString(playerTown.getNumberOfClaimedChunk()), Integer.toString(playerTown.getLevel().getChunkCap())));
    }

    @Override
    public void playerEnterClaimedArea(Player player, boolean displayTerritoryColor) {
        TownData townTo = this.getTown();
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        TextComponent name = displayTerritoryColor ? townTo.getCustomColoredName() : new TextComponent(townTo.getBaseColoredName());
        String message = Lang.PLAYER_ENTER_TERRITORY_CHUNK.get(tanPlayer.getPlayer(), name.toLegacyText());
        player.sendTitle("", message, 5, 40, 20);
        TextComponent textComponent = new TextComponent(townTo.getDescription());
        textComponent.setColor(ChatColor.GRAY);
        textComponent.setItalic(Boolean.valueOf(true));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)textComponent);
        TownData playerTown = tanPlayer.getTown();
        if (playerTown == null) {
            return;
        }
        TownRelation relation = playerTown.getRelationWith(townTo);
        if (relation == TownRelation.WAR && ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("notifyEnemyEnterTown", true)) {
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.BAD);
            player.sendMessage(Lang.CHUNK_ENTER_TOWN_AT_WAR.get(tanPlayer.getLang(), new String[0]));
            townTo.broadcastMessageWithSound(Lang.CHUNK_INTRUSION_ALERT.get(TownDataStorage.getInstance().get(player).getName(), player.getName()), SoundEnum.BAD);
        }
    }

    @Override
    public boolean canEntitySpawn(EntityType entityType) {
        return this.getTown().getChunkSettings().getSpawnControl(entityType.toString()).canSpawn();
    }

    @Override
    public boolean canTerritoryClaim(TerritoryData territoryData) {
        return territoryData.canConquerChunk(this);
    }

    @Override
    public boolean isClaimed() {
        return true;
    }

    @Override
    public ChunkType getType() {
        return ChunkType.TOWN;
    }

    @Override
    public void notifyUpdate() {
        if (!Constants.allowNonAdjacentChunksForTown()) {
            ChunkUtil.unclaimIfNoLongerSupplied(this);
        }
    }
}

