/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.territory;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.position.Vector2D;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.Level;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.TeleportationPosition;
import org.leralix.tan.dataclass.TownUpgrade;
import org.leralix.tan.dataclass.chunk.TownClaimedChunk;
import org.leralix.tan.dataclass.newhistory.PlayerTaxHistory;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.economy.Budget;
import org.leralix.tan.dataclass.territory.economy.OverlordTaxLine;
import org.leralix.tan.dataclass.territory.economy.PlayerTaxLine;
import org.leralix.tan.dataclass.territory.economy.PropertyCreationTaxLine;
import org.leralix.tan.dataclass.territory.economy.PropertyRentTaxLine;
import org.leralix.tan.dataclass.territory.economy.PropertySellTaxLine;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.PlayerJoinTownAcceptedInternalEvent;
import org.leralix.tan.events.events.PlayerJoinTownRequestInternalEvent;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.TerritoryMemberMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.graphic.PrefixUtil;
import org.leralix.tan.utils.graphic.TeamUtils;
import org.leralix.tan.utils.text.StringUtil;

public class TownData
extends TerritoryData {
    private String UuidLeader;
    private String townTag;
    private boolean isRecruiting = false;
    private Level townLevel = new Level();
    private HashSet<String> PlayerJoinRequestSet = new HashSet();
    private Map<String, PropertyData> propertyDataMap;
    private TeleportationPosition teleportationPosition;
    private final HashSet<String> townPlayerListId = new HashSet();
    private Vector2D capitalLocation;

    public TownData(String townId, String townName) {
        this(townId, townName, null);
    }

    public TownData(String townId, String townName, ITanPlayer leader) {
        super(townId, townName, leader);
        if (leader != null) {
            this.UuidLeader = leader.getID();
            this.addPlayer(leader);
        }
        int prefixSize = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("prefixSize", 3);
        this.townTag = townName.length() >= prefixSize ? townName.substring(0, prefixSize).toUpperCase() : townName.toUpperCase();
    }

    @Override
    public RankData getRank(ITanPlayer tanPlayer) {
        return this.getRank(tanPlayer.getTownRankID());
    }

    public Level getLevel() {
        return this.townLevel;
    }

    public void addPlayer(String tanPlayerID) {
        this.addPlayer(PlayerDataStorage.getInstance().get(tanPlayerID));
    }

    public void addPlayer(ITanPlayer tanNewPlayer) {
        this.townPlayerListId.add(tanNewPlayer.getID());
        this.getTownDefaultRank().addPlayer(tanNewPlayer);
        tanNewPlayer.joinTown(this);
        Player newMember = tanNewPlayer.getPlayer();
        if (newMember != null) {
            newMember.sendMessage(Lang.TOWN_INVITATION_ACCEPTED_MEMBER_SIDE.get(tanNewPlayer.getLang(), this.getBaseColoredName()));
        }
        tanNewPlayer.clearAllTownApplications();
        for (TerritoryData overlords : this.getOverlords()) {
            overlords.registerPlayer(tanNewPlayer);
        }
        EventManager.getInstance().callEvent(new PlayerJoinTownAcceptedInternalEvent(tanNewPlayer, this));
        TeamUtils.updateAllScoreboardColor();
        PrefixUtil.updatePrefix(tanNewPlayer.getPlayer());
        TownDataStorage.getInstance().save();
    }

    public void removePlayer(String tanPlayerID) {
        this.removePlayer(PlayerDataStorage.getInstance().get(tanPlayerID));
    }

    public void removePlayer(ITanPlayer tanPlayer) {
        for (TerritoryData overlords : this.getOverlords()) {
            overlords.unregisterPlayer(tanPlayer);
        }
        this.getRank(tanPlayer).removePlayer(tanPlayer);
        this.townPlayerListId.remove(tanPlayer.getID());
        tanPlayer.leaveTown();
        TownDataStorage.getInstance().save();
        PrefixUtil.updatePrefix(tanPlayer.getPlayer());
    }

    @Override
    public Collection<String> getPlayerIDList() {
        return this.townPlayerListId;
    }

    @Override
    public Collection<ITanPlayer> getITanPlayerList() {
        ArrayList<ITanPlayer> ITanPlayerList = new ArrayList<ITanPlayer>();
        for (String playerID : this.getPlayerIDList()) {
            ITanPlayerList.add(PlayerDataStorage.getInstance().get(playerID));
        }
        return ITanPlayerList;
    }

    @Override
    public ItemStack getIconWithName() {
        ItemStack itemStack = this.getIcon();
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.getName());
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    @Override
    public ItemStack getIconWithInformations(LangType langType) {
        ItemStack icon = this.getIcon();
        ItemMeta meta = icon.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.getName());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Lang.GUI_TOWN_INFO_DESC0.get(langType, this.getDescription()));
            lore.add(Lang.GUI_TOWN_INFO_DESC1.get(langType, this.getLeaderName()));
            lore.add(Lang.GUI_TOWN_INFO_DESC2.get(langType, Integer.toString(this.getPlayerIDList().size())));
            lore.add(Lang.GUI_TOWN_INFO_DESC3.get(langType, Integer.toString(this.getNumberOfClaimedChunk())));
            lore.add(this.getOverlord().map(overlord -> Lang.GUI_TOWN_INFO_DESC5_REGION.get(langType, overlord.getName())).orElseGet(() -> Lang.GUI_TOWN_INFO_DESC5_NO_REGION.get(langType, new String[0])));
            meta.setLore(lore);
            icon.setItemMeta(meta);
        }
        return icon;
    }

    @Override
    public int getHierarchyRank() {
        return 0;
    }

    @Override
    public String getBaseColoredName() {
        return "\u00a79" + this.getName();
    }

    @Override
    public String getLeaderID() {
        if (this.UuidLeader == null) {
            return this.townPlayerListId.iterator().next();
        }
        return this.UuidLeader;
    }

    @Override
    public ITanPlayer getLeaderData() {
        return PlayerDataStorage.getInstance().get(this.UuidLeader);
    }

    @Override
    public void setLeaderID(String leaderID) {
        this.UuidLeader = leaderID;
    }

    @Override
    public boolean isLeader(String leaderID) {
        return this.getLeaderID().equals(leaderID);
    }

    @Override
    protected Collection<TerritoryData> getOverlords() {
        ArrayList<TerritoryData> overlords = new ArrayList<TerritoryData>();
        if (this.haveOverlord()) {
            RegionData regionData = this.getRegion();
            overlords.add(regionData);
            regionData.getOverlord().ifPresent(overlords::add);
        }
        return overlords;
    }

    @Override
    public void broadCastMessage(FilledLang message) {
        for (String playerId : this.townPlayerListId) {
            Player player = Bukkit.getServer().getPlayer(UUID.fromString(playerId));
            if (player == null || !player.isOnline()) continue;
            player.sendMessage(message.get(player));
        }
    }

    @Override
    public void broadcastMessageWithSound(FilledLang message, SoundEnum soundEnum, boolean addPrefix) {
        for (String playerId : this.townPlayerListId) {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(playerId));
            if (player == null || !player.isOnline()) continue;
            SoundUtil.playSound((Player)player, (SoundEnum)soundEnum);
            if (addPrefix) {
                player.sendMessage(message.get(player));
                continue;
            }
            player.sendMessage(message.get(player));
        }
    }

    @Override
    public void broadcastMessageWithSound(FilledLang message, SoundEnum soundEnum) {
        this.broadcastMessageWithSound(message, soundEnum, true);
    }

    public RankData getTownDefaultRank() {
        return this.getRank(this.getDefaultRankID());
    }

    public boolean isFull() {
        return this.townPlayerListId.size() >= this.townLevel.getPlayerCap();
    }

    @Override
    public boolean canClaimMoreChunk() {
        return this.getNumberOfClaimedChunk() < this.townLevel.getChunkCap();
    }

    public void addPlayerJoinRequest(Player player) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        EventManager.getInstance().callEvent(new PlayerJoinTownRequestInternalEvent(tanPlayer, this));
        this.addPlayerJoinRequest(tanPlayer.getID());
    }

    public void addPlayerJoinRequest(String playerUUID) {
        this.PlayerJoinRequestSet.add(playerUUID);
    }

    public void removePlayerJoinRequest(String playerUUID) {
        this.PlayerJoinRequestSet.remove(playerUUID);
    }

    public void removePlayerJoinRequest(Player player) {
        this.removePlayerJoinRequest(player.getUniqueId().toString());
    }

    public boolean isPlayerAlreadyRequested(String playerUUID) {
        return this.PlayerJoinRequestSet.contains(playerUUID);
    }

    public boolean isPlayerAlreadyRequested(Player player) {
        return this.isPlayerAlreadyRequested(player.getUniqueId().toString());
    }

    public Set<String> getPlayerJoinRequestSet() {
        return this.PlayerJoinRequestSet;
    }

    public boolean isRecruiting() {
        return this.isRecruiting;
    }

    public void swapRecruiting() {
        this.isRecruiting = !this.isRecruiting;
    }

    @Override
    protected void collectTaxes() {
        for (ITanPlayer tanPlayer : this.getITanPlayerList()) {
            OfflinePlayer offlinePlayer = tanPlayer.getOfflinePlayer();
            if (!this.getRank(tanPlayer).isPayingTaxes()) continue;
            double tax = this.getTax();
            if (EconomyUtil.getBalance(offlinePlayer) > tax) {
                EconomyUtil.removeFromBalance(offlinePlayer, tax);
                this.addToBalance(tax);
                TownsAndNations.getPlugin().getDatabaseHandler().addTransactionHistory(new PlayerTaxHistory(this, tanPlayer, tax));
                continue;
            }
            TownsAndNations.getPlugin().getDatabaseHandler().addTransactionHistory(new PlayerTaxHistory(this, tanPlayer, -1.0));
        }
    }

    @Override
    public double getChunkUpkeepCost() {
        return ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getDouble("TownChunkUpkeepCost", 0.0);
    }

    public void setSpawn(Location location) {
        this.teleportationPosition = new TeleportationPosition(location);
    }

    public boolean isSpawnSet() {
        return this.teleportationPosition != null;
    }

    public TeleportationPosition getSpawn() {
        return this.teleportationPosition;
    }

    public boolean isSpawnLocked() {
        return this.townLevel.getBenefitsLevel("UNLOCK_TOWN_SPAWN") <= 0;
    }

    @Override
    public boolean abstractClaimChunk(Player player, Chunk chunk, boolean ignoreAdjacent) {
        this.removeFromBalance(Constants.territoryClaimTownCost());
        NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(NewClaimedChunkStorage.getInstance().get(chunk));
        TownClaimedChunk chunkClaimed = NewClaimedChunkStorage.getInstance().claimTownChunk(chunk, this.getID());
        if (this.getNumberOfClaimedChunk() == 1) {
            this.setCapitalLocation(chunkClaimed.getVector2D());
        }
        player.sendMessage(Lang.CHUNK_CLAIMED_SUCCESS.get(player, Integer.toString(this.getNumberOfClaimedChunk()), Integer.toString(this.getLevel().getChunkCap())));
        return true;
    }

    @Override
    public int getClaimCost() {
        return Constants.territoryClaimTownCost();
    }

    public void setCapitalLocation(Vector2D vector2D) {
        this.capitalLocation = vector2D;
    }

    public Optional<Vector2D> getCapitalLocation() {
        return Optional.ofNullable(this.capitalLocation);
    }

    public RegionData getRegion() {
        return (RegionData)RegionDataStorage.getInstance().get(this.overlordID);
    }

    @Override
    public Collection<TerritoryData> getPotentialVassals() {
        return Collections.emptyList();
    }

    @Override
    public void removeOverlordPrivate() {
        for (ITanPlayer tanPlayer : this.getITanPlayerList()) {
            tanPlayer.setRegionRankID(null);
        }
    }

    @Override
    protected void addVassalPrivate(TerritoryData vassal) {
    }

    @Override
    protected void removeVassal(TerritoryData vassal) {
    }

    @Override
    public TerritoryData getCapital() {
        return null;
    }

    @Override
    public List<GuiItem> getOrderedMemberList(ITanPlayer tanPlayer) {
        Player player = tanPlayer.getPlayer();
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        LangType langType = tanPlayer.getLang();
        for (String playerUUID : this.getOrderedPlayerIDList()) {
            OfflinePlayer playerIterate = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID));
            ITanPlayer playerIterateData = PlayerDataStorage.getInstance().get(playerUUID);
            ItemStack playerHead = HeadUtils.getPlayerHead(playerIterate, Lang.GUI_TOWN_MEMBER_DESC1.get(langType, playerIterateData.getTownRank().getColoredName()), Lang.GUI_TOWN_MEMBER_DESC2.get(langType, StringUtil.formatMoney(EconomyUtil.getBalance(playerIterate))), this.doesPlayerHavePermission(tanPlayer, RolePermission.KICK_PLAYER) ? Lang.GUI_TOWN_MEMBER_DESC3.get(langType, new String[0]) : "");
            GuiItem playerButton = ItemBuilder.from(playerHead).asGuiItem(event -> {
                event.setCancelled(true);
                if (event.getClick() == ClickType.RIGHT) {
                    ITanPlayer kickedPlayer = PlayerDataStorage.getInstance().get(playerIterate);
                    TownData townData = TownDataStorage.getInstance().get(tanPlayer);
                    if (!this.doesPlayerHavePermission(tanPlayer, RolePermission.KICK_PLAYER)) {
                        player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(langType, new String[0]));
                        return;
                    }
                    if (townData.getRank(kickedPlayer).isSuperiorTo(townData.getRank(tanPlayer))) {
                        player.sendMessage(Lang.PLAYER_NO_PERMISSION_RANK_DIFFERENCE.get(langType, new String[0]));
                        return;
                    }
                    if (this.isLeader(kickedPlayer)) {
                        player.sendMessage(Lang.GUI_TOWN_MEMBER_CANT_KICK_LEADER.get(langType, new String[0]));
                        return;
                    }
                    if (tanPlayer.getID().equals(kickedPlayer.getID())) {
                        player.sendMessage(Lang.GUI_TOWN_MEMBER_CANT_KICK_YOURSELF.get(langType, new String[0]));
                        return;
                    }
                    PlayerGUI.openConfirmMenu(player, Lang.CONFIRM_PLAYER_KICKED.get(langType, playerIterate.getName()), confirmAction -> {
                        this.kickPlayer(playerIterate);
                        new TerritoryMemberMenu(player, this).open();
                    }, p -> new TerritoryMemberMenu(player, this).open());
                }
            });
            res.add(playerButton);
        }
        return res;
    }

    @Override
    protected void specificSetPlayerRank(ITanPlayer tanPlayer, int rankID) {
        tanPlayer.setTownRankID(rankID);
    }

    @Override
    protected void addSpecificTaxes(Budget budget) {
        budget.addProfitLine(new PlayerTaxLine(this));
        this.getOverlord().ifPresent(overlord -> budget.addProfitLine(new OverlordTaxLine(this, (TerritoryData)overlord)));
        budget.addProfitLine(new PropertyRentTaxLine(this));
        budget.addProfitLine(new PropertySellTaxLine(this));
        budget.addProfitLine(new PropertyCreationTaxLine(this));
    }

    public Map<String, PropertyData> getPropertyDataMap() {
        if (this.propertyDataMap == null) {
            this.propertyDataMap = new HashMap<String, PropertyData>();
        }
        return this.propertyDataMap;
    }

    public Collection<PropertyData> getProperties() {
        return this.getPropertyDataMap().values();
    }

    public String nextPropertyID() {
        if (this.getPropertyDataMap().isEmpty()) {
            return "P0";
        }
        int size = this.getPropertyDataMap().size();
        int lastID = Integer.parseInt(this.getPropertyDataMap().values().stream().toList().get(size - 1).getTotalID().split("P")[1]);
        return "P" + (lastID + 1);
    }

    public PropertyData registerNewProperty(Vector3D p1, Vector3D p2, ITanPlayer owner) {
        String propertyID = this.nextPropertyID();
        String id = this.getID() + "_" + propertyID;
        PropertyData newProperty = new PropertyData(id, p1, p2, owner);
        this.propertyDataMap.put(propertyID, newProperty);
        owner.addProperty(newProperty);
        return newProperty;
    }

    public PropertyData getProperty(String id) {
        return this.getPropertyDataMap().get(id);
    }

    public PropertyData getProperty(Location location) {
        for (PropertyData propertyData : this.getProperties()) {
            if (!propertyData.containsLocation(location)) continue;
            return propertyData;
        }
        return null;
    }

    public void removeProperty(PropertyData propertyData) {
        this.propertyDataMap.remove(propertyData.getPropertyID());
    }

    public String getTownTag() {
        if (this.townTag == null) {
            this.setTownTag(this.name.substring(0, 3).toUpperCase());
        }
        return this.townTag;
    }

    public void setTownTag(String townTag) {
        this.townTag = townTag;
        this.applyToAllOnlinePlayer(PrefixUtil::updatePrefix);
    }

    public String getColoredTag() {
        return String.valueOf(this.getChunkColor()) + "[" + this.getTownTag() + "]";
    }

    public void kickPlayer(OfflinePlayer kickedPlayer) {
        ITanPlayer kickedITanPlayer = PlayerDataStorage.getInstance().get(kickedPlayer);
        this.removePlayer(kickedITanPlayer);
        this.broadcastMessageWithSound(Lang.GUI_TOWN_MEMBER_KICKED_SUCCESS.get(kickedPlayer.getName()), SoundEnum.BAD);
        Player player = kickedPlayer.getPlayer();
        if (player != null) {
            kickedPlayer.getPlayer().sendMessage(Lang.GUI_TOWN_MEMBER_KICKED_SUCCESS_PLAYER.get(player));
        }
    }

    public void upgradeTown(Player player) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        Level level = this.getLevel();
        if (!this.doesPlayerHavePermission(tanPlayer, RolePermission.UPGRADE_TOWN)) {
            player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(player));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.NOT_ALLOWED);
            return;
        }
        if (this.getBalance() < (double)level.getMoneyRequiredForLevelUp()) {
            player.sendMessage(Lang.TERRITORY_NOT_ENOUGH_MONEY.get(player, this.getColoredName(), Double.toString((double)level.getMoneyRequiredForLevelUp() - this.getBalance())));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.NOT_ALLOWED);
            return;
        }
        this.removeFromBalance(level.getMoneyRequiredForLevelUp());
        level.townLevelUp();
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.LEVEL_UP);
        player.sendMessage(Lang.BASIC_LEVEL_UP.get(player));
    }

    public void upgradeTown(Player player, TownUpgrade townUpgrade, int townUpgradeLevel) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        if (!this.doesPlayerHavePermission(tanPlayer, RolePermission.UPGRADE_TOWN)) {
            player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(player));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.NOT_ALLOWED);
            return;
        }
        int cost = townUpgrade.getCost(this.townLevel.getUpgradeLevel(townUpgrade.getName()));
        if (this.getBalance() < (double)cost) {
            player.sendMessage(Lang.TERRITORY_NOT_ENOUGH_MONEY.get(player, this.getColoredName(), Double.toString((double)cost - this.getBalance())));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.NOT_ALLOWED);
            return;
        }
        Level level = this.getLevel();
        if (level.getUpgradeLevel(townUpgrade.getName()) >= townUpgrade.getMaxLevel()) {
            player.sendMessage(Lang.TOWN_UPGRADE_MAX_LEVEL.get(player));
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.NOT_ALLOWED);
            return;
        }
        this.removeFromBalance(townUpgrade.getCost(townUpgradeLevel));
        level.levelUp(townUpgrade);
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.LEVEL_UP);
        player.sendMessage(Lang.BASIC_LEVEL_UP.get(player));
    }

    @Override
    public boolean haveNoLeader() {
        return this.UuidLeader == null;
    }

    public boolean canClaimMoreLandmarks() {
        return this.getLevel().getTotalBenefits().get("MAX_LANDMARKS") > LandmarkStorage.getInstance().getLandmarkOf(this).size();
    }

    public void removeAllLandmark() {
        for (Landmark landmark : LandmarkStorage.getInstance().getLandmarkOf(this)) {
            landmark.removeOwnership();
        }
    }

    @Override
    public synchronized void delete() {
        super.delete();
        if (this.haveOverlord()) {
            RegionData regionData = this.getRegion();
            regionData.removeVassal(this);
        }
        this.removeAllLandmark();
        this.removeAllProperty();
        ArrayList<String> playersToRemove = new ArrayList<String>(this.getPlayerIDList());
        for (String playerID : playersToRemove) {
            this.removePlayer(playerID);
        }
        TeamUtils.updateAllScoreboardColor();
        TownDataStorage.getInstance().deleteTown(this);
    }

    private void removeAllProperty() {
        Iterator<PropertyData> iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            PropertyData propertyData = iterator.next();
            propertyData.delete();
            iterator.remove();
        }
    }

    @Override
    public void openMainMenu(Player player) {
        PlayerGUI.dispatchPlayerTown(player);
    }

    @Override
    public boolean canHaveVassals() {
        return false;
    }

    @Override
    public boolean canHaveOverlord() {
        return true;
    }

    @Override
    public List<String> getVassalsID() {
        return Collections.emptyList();
    }

    @Override
    public boolean isVassal(String territoryID) {
        return false;
    }
}

