/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.territory.cosmetic;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.cosmetic.ICustomIcon;
import org.leralix.tan.storage.stored.PremiumStorage;

public class PlayerHeadIcon
implements ICustomIcon {
    private final String playerUUID;

    public PlayerHeadIcon(ITanPlayer player) {
        this.playerUUID = player == null ? null : player.getID();
    }

    public PlayerHeadIcon(String playerID) {
        this.playerUUID = playerID;
    }

    @Override
    public ItemStack getIcon() {
        if (this.playerUUID == null) {
            return new ItemStack(Material.SKELETON_SKULL);
        }
        ItemStack icon = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)icon.getItemMeta();
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.playerUUID));
        if (skullMeta == null || !PremiumStorage.getInstance().isPremium(offlinePlayer.getName())) {
            return icon;
        }
        skullMeta.setOwnerProfile((PlayerProfile)offlinePlayer.getPlayerProfile());
        icon.setItemMeta((ItemMeta)skullMeta);
        return icon;
    }
}

