/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.territory.permission;

import org.bukkit.ChatColor;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;

public enum RelationPermission {
    TOWN(Lang.TOWN_PERMISSION, ChatColor.GREEN),
    ALLIANCE(Lang.ALLIANCE_PERMISSION, ChatColor.BLUE),
    FOREIGN(Lang.EVERYONE_PERMISSION, ChatColor.WHITE),
    SELECTED_ONLY(Lang.SELECTED_ONLY_PERMISSION, ChatColor.GRAY);

    private final Lang name;
    private final ChatColor color;
    private RelationPermission next;

    private RelationPermission(Lang name, ChatColor color) {
        this.name = name;
        this.color = color;
    }

    public String getName(LangType langType) {
        return this.name.get(langType, new String[0]);
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getColoredName(LangType langType) {
        return String.valueOf(this.color) + this.getName(langType);
    }

    public RelationPermission getNext() {
        return this.next;
    }

    public boolean isAllowed(TerritoryData territoryToCheck, ITanPlayer tanPlayer) {
        switch (this.ordinal()) {
            case 0: {
                return territoryToCheck.isPlayerIn(tanPlayer);
            }
            case 1: {
                if (territoryToCheck.isPlayerIn(tanPlayer)) {
                    return true;
                }
                for (TerritoryData playerTerritory : tanPlayer.getAllTerritoriesPlayerIsIn()) {
                    if (territoryToCheck.getRelations().getRelationWith(playerTerritory) != TownRelation.ALLIANCE) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    static {
        RelationPermission.TOWN.next = ALLIANCE;
        RelationPermission.ALLIANCE.next = FOREIGN;
        RelationPermission.FOREIGN.next = SELECTED_ONLY;
        RelationPermission.SELECTED_ONLY.next = TOWN;
    }
}

