/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.enums;

import org.bukkit.ChatColor;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.tan.api.enums.EDiplomacyState;

public enum TownRelation {
    SELF(8, Lang.RELATION_CITY_NAME, ChatColor.DARK_GREEN, false),
    OVERLORD(7, Lang.RELATION_OVERLORD_NAME, ChatColor.GREEN, false),
    VASSAL(6, Lang.RELATION_VASSAL_NAME, ChatColor.DARK_PURPLE, false),
    ALLIANCE(5, Lang.RELATION_ALLIANCE_NAME, ChatColor.BLUE, true),
    NON_AGGRESSION(4, Lang.RELATION_NON_AGGRESSION_NAME, ChatColor.DARK_AQUA, true),
    NEUTRAL(3, Lang.RELATION_NEUTRAL_NAME, ChatColor.GRAY, true),
    EMBARGO(2, Lang.RELATION_EMBARGO_NAME, ChatColor.GOLD, true),
    WAR(1, Lang.RELATION_HOSTILE_NAME, ChatColor.RED, true);

    private final int rank;
    private final Lang name;
    private final ChatColor color;
    private final boolean canBeChanged;

    private TownRelation(int rank, Lang name, ChatColor color, boolean canBeChanged) {
        this.rank = rank;
        this.name = name;
        this.color = color;
        this.canBeChanged = canBeChanged;
    }

    public String getName(LangType langType) {
        return this.name.get(langType, new String[0]);
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getColoredName(LangType langType) {
        return String.valueOf(this.color) + this.getName(langType);
    }

    public boolean canBeChanged() {
        return this.canBeChanged;
    }

    public boolean isSuperiorTo(TownRelation oldRelation) {
        return this.rank > oldRelation.rank;
    }

    public EDiplomacyState toAPI() {
        return switch (this.ordinal()) {
            case 3 -> EDiplomacyState.ALLIANCE;
            case 4 -> EDiplomacyState.NON_AGGRESSION;
            case 5 -> EDiplomacyState.NEUTRAL;
            case 6 -> EDiplomacyState.EMBARGO;
            case 7 -> EDiplomacyState.WAR;
            default -> EDiplomacyState.NEUTRAL;
        };
    }

    public static TownRelation fromAPI(EDiplomacyState state) {
        return switch (state) {
            case EDiplomacyState.ALLIANCE -> ALLIANCE;
            case EDiplomacyState.NON_AGGRESSION -> NON_AGGRESSION;
            case EDiplomacyState.NEUTRAL -> NEUTRAL;
            case EDiplomacyState.EMBARGO -> EMBARGO;
            case EDiplomacyState.WAR -> WAR;
            default -> NEUTRAL;
        };
    }
}

