/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.events;

import org.leralix.tan.api.internal.wrappers.TerritoryDataWrapper;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.events.InternalEvent;
import org.tan.api.enums.EDiplomacyState;
import org.tan.api.events.DiplomacyProposalAcceptedEvent;
import org.tan.api.interfaces.TanTerritory;

public class DiplomacyProposalAcceptedInternalEvent
extends InternalEvent
implements DiplomacyProposalAcceptedEvent {
    private final TerritoryData proposedTerritory;
    private final TerritoryData acceptingTerritory;
    private final TownRelation oldRelation;
    private final TownRelation newRelation;

    public DiplomacyProposalAcceptedInternalEvent(TerritoryData proposedTerritory, TerritoryData acceptingTerritory, TownRelation oldRelation, TownRelation newRelation) {
        this.proposedTerritory = proposedTerritory;
        this.acceptingTerritory = acceptingTerritory;
        this.oldRelation = oldRelation;
        this.newRelation = newRelation;
    }

    @Override
    public TanTerritory getProposingTerritory() {
        return TerritoryDataWrapper.of(this.proposedTerritory);
    }

    @Override
    public TanTerritory getReceivingTerritory() {
        return TerritoryDataWrapper.of(this.acceptingTerritory);
    }

    @Override
    public EDiplomacyState getNewDiplomacy() {
        return this.newRelation.toAPI();
    }

    @Override
    public EDiplomacyState getOldDiplomacy() {
        return this.oldRelation.toAPI();
    }

    @Override
    public boolean isSuperior() {
        return this.newRelation.isSuperiorTo(this.oldRelation);
    }
}

