/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter;

import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.events.newsletter.news.AttackCancelledByDefenderNewsletter;
import org.leralix.tan.events.newsletter.news.AttackDeclaredNewsletter;
import org.leralix.tan.events.newsletter.news.AttackWonByAttackerNewsletter;
import org.leralix.tan.events.newsletter.news.AttackWonByDefenderNewsletter;
import org.leralix.tan.events.newsletter.news.DiplomacyAcceptedNews;
import org.leralix.tan.events.newsletter.news.DiplomacyProposalNews;
import org.leralix.tan.events.newsletter.news.LandmarkClaimedNewsletter;
import org.leralix.tan.events.newsletter.news.LandmarkUnclaimedNewsletter;
import org.leralix.tan.events.newsletter.news.PlayerJoinRequestNews;
import org.leralix.tan.events.newsletter.news.PlayerJoinTownNews;
import org.leralix.tan.events.newsletter.news.RegionCreationNews;
import org.leralix.tan.events.newsletter.news.RegionDeletedNews;
import org.leralix.tan.events.newsletter.news.TerritoryIndependentNews;
import org.leralix.tan.events.newsletter.news.TerritoryVassalAcceptedNews;
import org.leralix.tan.events.newsletter.news.TerritoryVassalForcedNews;
import org.leralix.tan.events.newsletter.news.TerritoryVassalProposalNews;
import org.leralix.tan.events.newsletter.news.TownCreatedNews;
import org.leralix.tan.events.newsletter.news.TownDeletedNews;
import org.tan.api.events.AttackCancelledByDefenderEvent;
import org.tan.api.events.AttackDeclaredEvent;
import org.tan.api.events.AttackWonByAttackerEvent;
import org.tan.api.events.DiplomacyProposalAcceptedEvent;
import org.tan.api.events.DiplomacyProposalEvent;
import org.tan.api.events.LandmarkClaimedEvent;
import org.tan.api.events.LandmarkUnclaimedEvent;
import org.tan.api.events.PlayerJoinRequestEvent;
import org.tan.api.events.PlayerJoinTownEvent;
import org.tan.api.events.RegionCreatedEvent;
import org.tan.api.events.RegionDeletedEvent;
import org.tan.api.events.TanListener;
import org.tan.api.events.TerritoryIndependenceEvent;
import org.tan.api.events.TerritoryVassalAcceptedEvent;
import org.tan.api.events.TerritoryVassalForcedEvent;
import org.tan.api.events.TerritoryVassalProposalEvent;
import org.tan.api.events.TownCreatedEvent;
import org.tan.api.events.TownDeletedEvent;

public class NewsletterEvents
implements TanListener {
    private final NewsletterStorage newsletterStorage = NewsletterStorage.getInstance();

    @TanListener.EventHandler
    public void onAttackDeclared(AttackDeclaredEvent event) {
        this.newsletterStorage.register(new AttackDeclaredNewsletter(event.getDefenderTerritory(), event.getAttackerTerritory()));
    }

    @TanListener.EventHandler
    public void onAttackWonByAttacker(AttackWonByAttackerEvent event) {
        this.newsletterStorage.register(new AttackWonByAttackerNewsletter(event.getAttackerTerritory(), event.getDefenderTerritory()));
    }

    @TanListener.EventHandler
    public void onAttackWonByDefender(AttackWonByAttackerEvent event) {
        this.newsletterStorage.register(new AttackWonByDefenderNewsletter(event.getAttackerTerritory(), event.getDefenderTerritory()));
    }

    @TanListener.EventHandler
    public void onDefenderAcceptDemands(AttackCancelledByDefenderEvent event) {
        this.newsletterStorage.register(new AttackCancelledByDefenderNewsletter(event.getDefenderTerritory(), event.getAttackerTerritory()));
    }

    @TanListener.EventHandler
    public void onDiplomacyProposalAccepted(DiplomacyProposalAcceptedEvent event) {
        this.newsletterStorage.register(new DiplomacyAcceptedNews(event.getProposingTerritory(), event.getReceivingTerritory(), event.getNewDiplomacy(), event.isSuperior()));
    }

    @TanListener.EventHandler
    public void onDiplomacyProposal(DiplomacyProposalEvent event) {
        this.newsletterStorage.register(new DiplomacyProposalNews(event.getProposingTerritory(), event.getReceivingTerritory(), event.getProposedDiplomacy()));
    }

    @TanListener.EventHandler
    public void onPlayerJoinTown(PlayerJoinTownEvent event) {
        this.newsletterStorage.register(new PlayerJoinTownNews(event.getPlayer(), event.getTown()));
    }

    @TanListener.EventHandler
    public void onPlayerRequestJoinTown(PlayerJoinRequestEvent event) {
        this.newsletterStorage.register(new PlayerJoinRequestNews(event.getPlayer(), event.getTown()));
    }

    @TanListener.EventHandler
    public void onRegionCreated(RegionCreatedEvent event) {
        this.newsletterStorage.register(new RegionCreationNews(event.getRegion(), event.getExecutor()));
    }

    @TanListener.EventHandler
    public void onRegionDeleted(RegionDeletedEvent event) {
        this.newsletterStorage.register(new RegionDeletedNews(event.getRegion(), event.getExecutor()));
    }

    @TanListener.EventHandler
    public void onTerritoryIndependence(TerritoryIndependenceEvent event) {
        this.newsletterStorage.register(new TerritoryIndependentNews(event.getTerritory(), event.getFormerOverlord()));
    }

    @TanListener.EventHandler
    public void onTerritoryVassalAccepted(TerritoryVassalAcceptedEvent event) {
        this.newsletterStorage.register(new TerritoryVassalAcceptedNews(event.getNewOverlord(), event.getTerritory()));
    }

    @TanListener.EventHandler
    public void onTerritoryVassalForced(TerritoryVassalForcedEvent event) {
        this.newsletterStorage.register(new TerritoryVassalForcedNews(event.getNewOverlord(), event.getTerritory()));
    }

    public void onTerritoryVassalProposal(TerritoryVassalProposalEvent event) {
        this.newsletterStorage.register(new TerritoryVassalProposalNews(event.getPotentialOverlord(), event.getTerritory()));
    }

    @TanListener.EventHandler
    public void onTownCreated(TownCreatedEvent event) {
        this.newsletterStorage.register(new TownCreatedNews(event.getTown(), event.getExecutor()));
    }

    @TanListener.EventHandler
    public void onTownDeleted(TownDeletedEvent event) {
        this.newsletterStorage.register(new TownDeletedNews(event.getTown(), event.getExecutor()));
    }

    @TanListener.EventHandler
    public void onLandmarkClaimed(LandmarkClaimedEvent event) {
        this.newsletterStorage.register(new LandmarkClaimedNewsletter(event.getLandmark(), event.getNewOwner()));
    }

    @TanListener.EventHandler
    public void onLandmarkUnclaimed(LandmarkUnclaimedEvent event) {
        this.newsletterStorage.register(new LandmarkUnclaimedNewsletter(event.getLandmark(), event.getOldOwner()));
    }
}

