/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.DiplomacyProposalNews;

public class DiplomacyProposalDAO
extends NewsletterSubDAO<DiplomacyProposalNews> {
    private static final String TABLE_NAME = "diplomacy_proposal_newsletter";

    public DiplomacyProposalDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS diplomacy_proposal_newsletter (id VARCHAR(36) PRIMARY KEY, proposingTerritoryID VARCHAR(36) NOT NULL, receivingTerritoryID VARCHAR(36) NOT NULL, wantedRelation VARCHAR(36) NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create diplomacy proposal newsletter table", e);
        }
    }

    @Override
    public void save(DiplomacyProposalNews newsletter) {
        String sql = "INSERT INTO diplomacy_proposal_newsletter (id, proposingTerritoryID, receivingTerritoryID, wantedRelation) VALUES (?, ?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getProposingTerritoryID());
            ps.setString(3, newsletter.getReceivingTerritoryID());
            ps.setString(4, newsletter.getWantedRelation().toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save diplomacy proposal newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DiplomacyProposalNews load(UUID id, long date) {
        String sql = "SELECT proposingTerritoryID, receivingTerritoryID, wantedRelation FROM diplomacy_proposal_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String proposingTerritoryID = rs.getString("proposingTerritoryID");
                String receivingTerritoryID = rs.getString("receivingTerritoryID");
                TownRelation wantedRelation = TownRelation.valueOf(rs.getString("wantedRelation"));
                DiplomacyProposalNews diplomacyProposalNews = new DiplomacyProposalNews(id, date, proposingTerritoryID, receivingTerritoryID, wantedRelation);
                return diplomacyProposalNews;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load diplomacy proposal newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM diplomacy_proposal_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table diplomacy_proposal_newsletter", e);
        }
    }
}

