/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.TerritoryVassalForcedNews;

public class TerritoryVassalForcedDAO
extends NewsletterSubDAO<TerritoryVassalForcedNews> {
    private static final String TABLE_NAME = "territory_vassal_forced_newsletter";

    public TerritoryVassalForcedDAO(DataSource connection) {
        super(connection);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS territory_vassal_forced_newsletter (id VARCHAR(36) PRIMARY KEY, proposingTerritoryID VARCHAR(36) NOT NULL, forcedTerritoryID VARCHAR(36) NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create table territory_vassal_forced_newsletter", e);
        }
    }

    @Override
    public void save(TerritoryVassalForcedNews newsletter) {
        String sql = "INSERT INTO territory_vassal_forced_newsletter (id, proposingTerritoryID, forcedTerritoryID) VALUES (?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getProposingTerritoryID());
            ps.setString(3, newsletter.getForcedTerritoryID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save to table territory_vassal_forced_newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TerritoryVassalForcedNews load(UUID id, long date) {
        String sql = "SELECT proposingTerritoryID, forcedTerritoryID FROM territory_vassal_forced_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String proposingTerritoryID = rs.getString("proposingTerritoryID");
                String forcedTerritoryID = rs.getString("forcedTerritoryID");
                TerritoryVassalForcedNews territoryVassalForcedNews = new TerritoryVassalForcedNews(id, date, proposingTerritoryID, forcedTerritoryID);
                return territoryVassalForcedNews;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load from table territory_vassal_forced_newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM territory_vassal_forced_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table territory_vassal_forced_newsletter", e);
        }
    }
}

