/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.news;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.events.newsletter.news.Newsletter;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.tan.api.interfaces.TanTerritory;

public class TerritoryIndependentNews
extends Newsletter {
    private final String formerMasterID;
    private final String independentTerritoryID;

    public TerritoryIndependentNews(TanTerritory independentTerritoryID, TanTerritory formerMasterID) {
        this.independentTerritoryID = independentTerritoryID.getID();
        this.formerMasterID = formerMasterID.getID();
    }

    public TerritoryIndependentNews(UUID id, long date, String independentTerritoryID, String formerMasterID) {
        super(id, date);
        this.independentTerritoryID = independentTerritoryID;
        this.formerMasterID = formerMasterID;
    }

    public String getFormerMasterID() {
        return this.formerMasterID;
    }

    public String getIndependentTerritoryID() {
        return this.independentTerritoryID;
    }

    @Override
    public GuiItem createGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        TerritoryData leavingTown = TerritoryUtil.getTerritory(this.formerMasterID);
        TerritoryData region = TerritoryUtil.getTerritory(this.independentTerritoryID);
        if (leavingTown == null || region == null) {
            return null;
        }
        ItemStack icon = HeadUtils.createCustomItemStack(Material.GOLDEN_HELMET, Lang.TOWN_LEAVE_REGION_NEWSLETTER_TITLE.get(lang, new String[0]), Lang.NEWSLETTER_DATE.get(lang, TimeZoneManager.getInstance().getRelativeTimeDescription(lang, this.getDate())), Lang.TOWN_LEAVE_REGION_NEWSLETTER.get(lang, leavingTown.getBaseColoredName(), region.getBaseColoredName()), Lang.NEWSLETTER_RIGHT_CLICK_TO_MARK_AS_READ.get(lang, new String[0]));
        return ItemBuilder.from(icon).asGuiItem(event -> {
            event.setCancelled(true);
            if (event.isRightClick()) {
                this.markAsRead(player);
                onClick.accept(player);
            }
        });
    }

    @Override
    public GuiItem createConcernedGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        return this.createGuiItem(player, lang, onClick);
    }

    @Override
    public boolean shouldShowToPlayer(Player player) {
        TerritoryData leavingTown = TerritoryUtil.getTerritory(this.formerMasterID);
        if (leavingTown == null) {
            return false;
        }
        TerritoryData region = TerritoryUtil.getTerritory(this.independentTerritoryID);
        if (region == null) {
            return false;
        }
        return leavingTown.isPlayerIn(player) || region.isPlayerIn(player);
    }

    @Override
    public NewsletterType getType() {
        return NewsletterType.TERRITORY_VASSAL_INDEPENDENT;
    }

    @Override
    public void broadcast(Player player) {
        TerritoryData leavingTown = TerritoryUtil.getTerritory(this.formerMasterID);
        if (leavingTown == null) {
            return;
        }
        TerritoryData region = TerritoryUtil.getTerritory(this.independentTerritoryID);
        if (region == null) {
            return;
        }
        player.sendMessage(Lang.TOWN_LEAVE_REGION_NEWSLETTER.get(player, leavingTown.getBaseColoredName(), region.getBaseColoredName()));
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
    }

    @Override
    public void broadcastConcerned(Player player) {
        this.broadcast(player);
    }
}

