/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.cosmetic.type;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.leralix.tan.gui.cosmetic.type.IconType;
import org.leralix.tan.gui.cosmetic.type.ItemIconBuilder;

public class IconBuilder {
    private String name;
    private final List<String> description = new ArrayList<String>();
    private Consumer<InventoryClickEvent> action;
    private boolean hideItemFlags = false;
    private final IconType menuIcon;

    public IconBuilder(IconType menuIcon) {
        this.menuIcon = menuIcon == null ? new ItemIconBuilder(Material.BARRIER) : menuIcon;
    }

    public IconBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public IconBuilder setDescription(String ... descriptions) {
        this.description.clear();
        this.description.addAll(List.of(descriptions));
        return this;
    }

    public IconBuilder setDescription(Collection<String> description) {
        this.description.clear();
        this.description.addAll(description);
        return this;
    }

    public IconBuilder setAction(Consumer<InventoryClickEvent> action) {
        this.action = action;
        return this;
    }

    public IconBuilder setHideItemFlags(boolean hideItemFlags) {
        this.hideItemFlags = hideItemFlags;
        return this;
    }

    public GuiItem asGuiItem(Player player) {
        ItemStack item = this.menuIcon.getItemStack(player);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.name);
            meta.setLore(this.description);
            if (this.hideItemFlags) {
                meta.getItemFlags().add(ItemFlag.HIDE_ATTRIBUTES);
                meta.getItemFlags().add(ItemFlag.HIDE_ENCHANTS);
                meta.getItemFlags().add(ItemFlag.HIDE_UNBREAKABLE);
                meta.getItemFlags().add(ItemFlag.HIDE_PLACED_ON);
                meta.getItemFlags().add(ItemFlag.HIDE_DYE);
            }
            item.setItemMeta(meta);
        }
        if (this.action == null) {
            return ItemBuilder.from(item).asGuiItem((InventoryClickEvent event) -> event.setCancelled(true));
        }
        return ItemBuilder.from(item).asGuiItem((InventoryClickEvent event) -> this.action.accept((InventoryClickEvent)event));
    }
}

